package org.appenders.log4j2.elasticsearch;

/*-
 * #%L
 * log4j2-elasticsearch
 * %%
 * Copyright (C) 2018 Rafal Foltynski
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


/**
 * An object that adds given items to the batch processor
 *
 * @param <T> type of accepted items
 */
public interface BatchDelivery<T> extends LifeCycle {

    String ELEMENT_TYPE = "batchDelivery";

    /**
     * @param indexName delivery target
     * @param log item to process
     */
    void add(String indexName,  T log);

    /**
     * @param indexName delivery target
     * @param log item source to process
     */
    void add(String indexName,  ItemSource log);

}
