/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.json.JsonWriteContextAccessor;
import org.junit.Assert;
import org.junit.Test;

public class JsonWriteContextAccessorTest {
    @Test
    public void resetResetsCurrentContextImmediatelyIfContextHasNoParent() {
        JsonWriteContextAccessor ctxAccess = new JsonWriteContextAccessor();
        JsonWriteContext context = new JsonWriteContext(0, null, null);
        JsonWriteContext ctxAfterReset = ctxAccess.reset(context);
        Assert.assertSame((Object)context, (Object)ctxAfterReset);
        Assert.assertEquals((long)ctxAccess.getType(ctxAfterReset), (long)0L);
    }

    @Test
    public void resetResetsAndReturnsRootContextIfContextHasParent() {
        JsonWriteContextAccessor ctxAccess = new JsonWriteContextAccessor();
        JsonWriteContext grandpaContext = new JsonWriteContext(0, null, null);
        JsonWriteContext parentContext = grandpaContext.createChildObjectContext();
        JsonWriteContext childContext = parentContext.createChildObjectContext();
        int childContextType = ctxAccess.getType(childContext);
        Assert.assertNotEquals((long)ctxAccess.getType(childContext), (long)0L);
        JsonWriteContext ctxAfterReset = ctxAccess.reset(childContext);
        Assert.assertSame((Object)grandpaContext, (Object)ctxAfterReset);
        Assert.assertEquals((long)0L, (long)ctxAccess.getType(ctxAfterReset));
        Assert.assertEquals((long)childContextType, (long)ctxAccess.getType(childContext));
    }
}

