/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.json.JsonWriteContextAccessor;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import org.appenders.log4j2.elasticsearch.OutputStreamDelegate;
import org.appenders.log4j2.elasticsearch.ReusableIOContext;
import org.appenders.log4j2.elasticsearch.ReusableUTF8JsonGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ReusableUTF8JsonGeneratorTest {
    @Test
    public void canReuseAfterCloseAndReset() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStream os2 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate delegate = (OutputStreamDelegate)Mockito.spy((Object)new OutputStreamDelegate(os1));
        ReusableIOContext ctx = ReusableUTF8JsonGeneratorTest.createDefaultTestIOContext((OutputStream)delegate);
        ReusableUTF8JsonGenerator gen = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(delegate, ctx);
        gen.writeStartObject();
        gen.writeEndObject();
        int expectedLength1 = gen._outputTail;
        gen.close();
        delegate.setDelegate(os2);
        ctx.setSourceReference(os2);
        gen.reset();
        gen.writeStartObject();
        gen.writeEndObject();
        int expectedLength2 = gen._outputTail;
        gen.close();
        ((OutputStream)Mockito.verify((Object)os1, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.eq((Object)gen._outputBuffer), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)expectedLength1));
        ((OutputStream)Mockito.verify((Object)os2, (VerificationMode)Mockito.times((int)1))).write((byte[])ArgumentMatchers.eq((Object)gen._outputBuffer), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)expectedLength2));
        ((OutputStreamDelegate)Mockito.verify((Object)delegate, (VerificationMode)Mockito.atLeastOnce())).write((byte[])ArgumentMatchers.eq((Object)gen._outputBuffer), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)expectedLength1));
    }

    @Test
    public void resetDelegatesToJsonWriteContextAccessor() {
        OutputStreamDelegate outputStreamDelegate = ReusableUTF8JsonGeneratorTest.createDefaultTestOutputStreamDelegate();
        ReusableIOContext ctx = ReusableUTF8JsonGeneratorTest.createDefaultTestIOContext((OutputStream)outputStreamDelegate);
        JsonWriteContextAccessor ctxAccess = (JsonWriteContextAccessor)Mockito.spy((Object)new JsonWriteContextAccessor());
        ReusableUTF8JsonGenerator jsonGenerator = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate, ctx, ctxAccess);
        jsonGenerator.reset();
        ((JsonWriteContextAccessor)Mockito.verify((Object)ctxAccess)).reset((JsonWriteContext)ArgumentMatchers.any(JsonWriteContext.class));
    }

    @Test
    public void closeClosesJsonContentIfEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = ReusableUTF8JsonGeneratorTest.createDefaultTestOutputStreamDelegate();
        ReusableIOContext ctx = ReusableUTF8JsonGeneratorTest.createDefaultTestIOContext((OutputStream)outputStreamDelegate);
        JsonWriteContextAccessor ctxAccess = (JsonWriteContextAccessor)Mockito.spy((Object)new JsonWriteContextAccessor());
        ReusableUTF8JsonGenerator jsonGenerator = (ReusableUTF8JsonGenerator)Mockito.spy((Object)ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate, ctx, ctxAccess));
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, true);
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inRoot());
        jsonGenerator.writeStartArray();
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inArray());
        jsonGenerator.writeStartObject();
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inObject());
        jsonGenerator.close();
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inRoot());
        Assert.assertFalse((boolean)jsonGenerator.getOutputContext().inArray());
        Assert.assertFalse((boolean)jsonGenerator.getOutputContext().inObject());
    }

    @Test
    public void closeDoesNotCloseJsonContentIfNotEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = ReusableUTF8JsonGeneratorTest.createDefaultTestOutputStreamDelegate();
        ReusableIOContext ctx = ReusableUTF8JsonGeneratorTest.createDefaultTestIOContext((OutputStream)outputStreamDelegate);
        JsonWriteContextAccessor ctxAccess = (JsonWriteContextAccessor)Mockito.spy((Object)new JsonWriteContextAccessor());
        ReusableUTF8JsonGenerator jsonGenerator = (ReusableUTF8JsonGenerator)Mockito.spy((Object)ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate, ctx, ctxAccess));
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inRoot());
        jsonGenerator.writeStartArray();
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inArray());
        jsonGenerator.writeStartObject();
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inObject());
        jsonGenerator.close();
        Assert.assertFalse((boolean)jsonGenerator.getOutputContext().inRoot());
        Assert.assertFalse((boolean)jsonGenerator.getOutputContext().inArray());
        Assert.assertTrue((boolean)jsonGenerator.getOutputContext().inObject());
    }

    @Test
    public void closeCloseTargetIfEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = (OutputStreamDelegate)Mockito.mock(OutputStreamDelegate.class);
        ReusableUTF8JsonGenerator jsonGenerator = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate);
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, true);
        jsonGenerator.close();
        ((OutputStreamDelegate)Mockito.verify((Object)outputStreamDelegate)).close();
    }

    @Test
    public void closeDoesNotCloseTargetIfNotEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = (OutputStreamDelegate)Mockito.mock(OutputStreamDelegate.class);
        ReusableUTF8JsonGenerator jsonGenerator = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate);
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonGenerator.close();
        ((OutputStreamDelegate)Mockito.verify((Object)outputStreamDelegate, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void closeFlushesTargetIfEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = (OutputStreamDelegate)Mockito.mock(OutputStreamDelegate.class);
        ReusableUTF8JsonGenerator jsonGenerator = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate);
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonGenerator.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, true);
        jsonGenerator.close();
        ((OutputStreamDelegate)Mockito.verify((Object)outputStreamDelegate)).flush();
    }

    @Test
    public void closeDoesNotFlushTargetIfNotEnabled() throws IOException {
        OutputStreamDelegate outputStreamDelegate = (OutputStreamDelegate)Mockito.mock(OutputStreamDelegate.class);
        ReusableUTF8JsonGenerator jsonGenerator = ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate);
        jsonGenerator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        jsonGenerator.configure(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM, false);
        jsonGenerator.close();
        ((OutputStreamDelegate)Mockito.verify((Object)outputStreamDelegate, (VerificationMode)Mockito.never())).flush();
    }

    public static OutputStreamDelegate createDefaultTestOutputStreamDelegate() {
        return new OutputStreamDelegate((OutputStream)Mockito.mock(OutputStream.class));
    }

    public static ReusableIOContext createDefaultTestIOContext(OutputStream delegate) {
        BufferRecycler recycler = new BufferRecycler();
        return new ReusableIOContext(recycler, delegate, false);
    }

    public static ReusableUTF8JsonGenerator createDefaultTestUTF8JsonGenerator(OutputStreamDelegate outputStreamDelegate) {
        return ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate, ReusableUTF8JsonGeneratorTest.createDefaultTestIOContext((OutputStream)outputStreamDelegate), new JsonWriteContextAccessor());
    }

    public static ReusableUTF8JsonGenerator createDefaultTestUTF8JsonGenerator(OutputStreamDelegate outputStreamDelegate, ReusableIOContext ctx) {
        return ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator(outputStreamDelegate, ctx, new JsonWriteContextAccessor());
    }

    public static ReusableUTF8JsonGenerator createDefaultTestUTF8JsonGenerator(OutputStreamDelegate outputStreamDelegate, ReusableIOContext ctx, JsonWriteContextAccessor jsonWriteCtxAccess) {
        return ReusableUTF8JsonGeneratorTest.createDefaultTestUTF8JsonGenerator((OutputStream)outputStreamDelegate, ctx, JsonGenerator.Feature.collectDefaults(), jsonWriteCtxAccess);
    }

    public static ReusableUTF8JsonGenerator createDefaultTestUTF8JsonGenerator(OutputStream delegate, ReusableIOContext ctx, int features, JsonWriteContextAccessor jsonWriteCtxAccess) {
        return new ReusableUTF8JsonGenerator((IOContext)ctx, features, (ObjectCodec)new ObjectMapper(), delegate, '\"', jsonWriteCtxAccess);
    }
}

