/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.UUID;
import org.apache.logging.log4j.core.jackson.JacksonJsonMessageSerializer;
import org.apache.logging.log4j.message.Message;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class JacksonJsonMessageSerializerTest {
    @Test
    public void serializerUsesFormatedMesage() throws IOException {
        JacksonJsonMessageSerializer serializer = new JacksonJsonMessageSerializer();
        Message message = (Message)Mockito.mock(Message.class);
        serializer.serialize((Object)message, (JsonGenerator)Mockito.mock(JsonGenerator.class), (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((Message)Mockito.verify((Object)message)).getFormattedMessage();
    }

    @Test
    public void serializerWritesRawValue() throws IOException {
        JacksonJsonMessageSerializer serializer = new JacksonJsonMessageSerializer();
        Message message = (Message)Mockito.mock(Message.class);
        String expectedValue = UUID.randomUUID().toString();
        Mockito.when((Object)message.getFormattedMessage()).thenReturn((Object)expectedValue);
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        serializer.serialize((Object)message, jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeRaw((String)Matchers.eq((Object)expectedValue));
    }
}

