/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.core.logging;

import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Log4j2StatusLoggerWrapper;
import org.appenders.core.logging.Logger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class InternalLoggingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void allowsToSetLogger() {
        Logger expectedLogger = (Logger)Mockito.mock(Logger.class);
        InternalLogging.setLogger((Logger)expectedLogger);
        Assert.assertEquals((Object)expectedLogger, (Object)InternalLogging.getLogger());
    }

    @Test
    public void returnsDefaultImplWhenLoggerNotSetAndNullLoggerIsAllowed() {
        System.setProperty("appenders.internalLogging.throwOnNull", "false");
        InternalLogging.setLogger(null);
        Logger logger = InternalLogging.getLogger();
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof Log4j2StatusLoggerWrapper));
    }

    @Test
    public void throwsWhenLoggerNotSetAndNullLoggerNotAllowed() {
        System.setProperty("appenders.internalLogging.throwOnNull", "true");
        InternalLogging.setLogger(null);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Logger cannot be null. Set Logger instance with InternalLogging.setLogger()()");
        InternalLogging.getLogger();
    }

    public static Logger mockTestLogger() {
        Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
        InternalLogging.setLogger((Logger)mockedLogger);
        return mockedLogger;
    }
}

