/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.core.util;

import org.appenders.core.logging.InternalLogging;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Integer getInt(String propertyName, int defaultValue) {
        String value = System.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            PropertiesUtil.logMissingValue(propertyName, defaultValue);
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            PropertiesUtil.logParsingError(propertyName, defaultValue, e);
            return defaultValue;
        }
    }

    private static void logMissingValue(String propertyName, int defaultValue) {
        InternalLogging.getLogger().warn("Property {} not found. Returning default: {}", new Object[]{propertyName, defaultValue});
    }

    private static void logParsingError(String propertyName, int defaultValue, Exception e) {
        InternalLogging.getLogger().error("{} {} while parsing {}. Returning default: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), propertyName, defaultValue});
    }
}

