/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.core.util;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.appenders.core.logging.InternalLoggingTest;
import org.appenders.core.logging.Logger;
import org.appenders.core.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PropertiesUtilTest {
    public static final int OFFSET = 1000;

    @Test
    public void getIntReturnsValueIfPropertyIsSet() {
        String propertyName = UUID.randomUUID().toString();
        int expectedValue = new Random().nextInt(1000) + 1000;
        System.setProperty(propertyName, String.valueOf(expectedValue));
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)expectedValue, (long)result);
    }

    @Test
    public void getIntReturnsDefaultIfPropertyIsNull() {
        String propertyName = UUID.randomUUID().toString();
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void getIntReturnsDefaultIfPropertyIsEmpty() {
        String propertyName = UUID.randomUUID().toString();
        System.setProperty(propertyName, "");
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void getIntReturnsDefaultIfPropertyIsBlank() {
        String propertyName = UUID.randomUUID().toString();
        System.setProperty(propertyName, "    ");
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void getIntLogsIfDefaultIsReturned() {
        Logger logger = InternalLoggingTest.mockTestLogger();
        String propertyName = UUID.randomUUID().toString();
        System.setProperty(propertyName, "    ");
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)1L, (long)result);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object[].class);
        ((Logger)Mockito.verify((Object)logger)).warn((String)ArgumentMatchers.eq((Object)"Property {} not found. Returning default: {}"), (Object[])captor.capture());
        List args = captor.getAllValues();
        Assert.assertEquals((Object)propertyName, args.get(0));
        Assert.assertEquals((Object)1, args.get(1));
    }

    @Test
    public void getIntLogsIfValueCannotBeParsed() {
        Logger logger = InternalLoggingTest.mockTestLogger();
        String propertyName = UUID.randomUUID().toString();
        String nonIntegerValue = UUID.randomUUID().toString();
        System.setProperty(propertyName, nonIntegerValue);
        int result = PropertiesUtil.getInt(propertyName, 1);
        Assert.assertEquals((long)1L, (long)result);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object[].class);
        ((Logger)Mockito.verify((Object)logger)).error((String)ArgumentMatchers.eq((Object)"{} {} while parsing {}. Returning default: {}"), (Object[])captor.capture());
        List args = captor.getAllValues();
        Assert.assertEquals((Object)NumberFormatException.class.getSimpleName(), args.get(0));
        Assert.assertTrue((boolean)((String)args.get(1)).contains(nonIntegerValue));
        Assert.assertEquals((Object)propertyName, args.get(2));
        Assert.assertEquals((Object)1, args.get(3));
    }
}

