/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.UUID;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.AppenderRefFailoverPolicy;
import org.appenders.log4j2.elasticsearch.ByteBufItemSource;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AppenderRefFailoverPolicyTest {
    @Test
    public void deliverStringDeliversToAppenderRef() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = UUID.randomUUID().toString();
        failoverPolicy.deliver((Object)failedMessage);
        ((Appender)Mockito.verify((Object)appender, (VerificationMode)Mockito.times((int)1))).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
    }

    @Test
    public void deliverItemSourceDelegates() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy(AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration));
        String failedMessage = UUID.randomUUID().toString();
        StringItemSource itemSource = new StringItemSource(failedMessage);
        failoverPolicy.deliver((ItemSource)itemSource);
        ((FailoverPolicy)Mockito.verify((Object)failoverPolicy)).deliver(ArgumentMatchers.eq((Object)failedMessage));
    }

    @Test
    public void deliverFailedItemSourceDelegates() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy(AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration));
        String failedMessage = UUID.randomUUID().toString();
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeBytes(failedMessage.getBytes());
        FailedItemSource itemSource = new FailedItemSource((ItemSource)new ByteBufItemSource(buffer, source -> {}), new FailedItemInfo(UUID.randomUUID().toString()));
        failoverPolicy.deliver(itemSource);
        ((FailoverPolicy)Mockito.verify((Object)failoverPolicy)).deliver(ArgumentMatchers.eq((Object)failedMessage));
    }

    @Test
    public void resolvesAppenderRefOnlyOnce() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn((Object)appender);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = "test failed message";
        failoverPolicy.deliver((Object)failedMessage);
        failoverPolicy.deliver((Object)failedMessage);
        ((Configuration)Mockito.verify((Object)configuration, (VerificationMode)Mockito.times((int)1))).getAppender(Mockito.anyString());
        ((Appender)Mockito.verify((Object)appender, (VerificationMode)Mockito.times((int)2))).append((LogEvent)ArgumentMatchers.any(LogEvent.class));
    }

    @Test(expected=ConfigurationException.class)
    public void throwsExceptionOnUnresolvedAppender() {
        Appender appender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)appender.isStarted()).thenReturn((Object)true);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        String testAppenderRef = "testAppenderRef";
        Mockito.when((Object)configuration.getAppender(testAppenderRef)).thenReturn(null);
        FailoverPolicy<String> failoverPolicy = AppenderRefFailoverPolicyTest.createTestFailoverPolicy(testAppenderRef, configuration);
        String failedMessage = "test failed message";
        failoverPolicy.deliver((Object)failedMessage);
    }

    public static FailoverPolicy<String> createTestFailoverPolicy(String testAppenderRef, Configuration configuration) {
        AppenderRefFailoverPolicy.Builder builder = AppenderRefFailoverPolicy.newBuilder();
        builder.withAppenderRef(AppenderRef.createAppenderRef((String)testAppenderRef, (Level)Level.ALL, null));
        builder.withConfiguration(configuration);
        return builder.build();
    }

    static {
        System.setProperty("io.netty.allocator.maxOrder", "2");
    }
}

