/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.Random;
import java.util.UUID;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.AsyncBatchDelivery;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.BulkEmitterTest;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.Operation;
import org.appenders.log4j2.elasticsearch.TestBatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.TestHttpObjectFactory;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailoverListener;
import org.appenders.log4j2.elasticsearch.mock.LifecycleTestHelper;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchDeliveryTest {
    private static final int TEST_BATCH_SIZE = 100;
    private static final int TEST_DELIVERY_INTERVAL = 100;
    public static final String TEST_SERVER_URIS = "http://localhost:9200";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static TestHttpObjectFactory.Builder createTestObjectFactoryBuilder() {
        TestHttpObjectFactory.Builder builder = TestHttpObjectFactory.newBuilder();
        builder.withServerUris(TEST_SERVER_URIS);
        return builder;
    }

    public static AsyncBatchDelivery.Builder createTestBatchDeliveryBuilder() {
        return ((AsyncBatchDelivery.Builder)Mockito.spy((Object)AsyncBatchDelivery.newBuilder().withBatchSize(100).withDeliveryInterval(100).withClientObjectFactory((ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build()))).withFailoverPolicy((FailoverPolicy)new NoopFailoverPolicy()).withIndexTemplate(new IndexTemplate("testIndexTemplate", "classpath:indexTemplate.json"));
    }

    @Test
    public void builderReturnsNonNullObject() {
        AsyncBatchDelivery.Builder batchDeliveryBuilder = BatchDeliveryTest.createTestBatchDeliveryBuilder();
        AsyncBatchDelivery delivery = batchDeliveryBuilder.build();
        Assert.assertNotNull((Object)delivery);
    }

    @Test(expected=ConfigurationException.class)
    public void builderFailsWhenClientObjectFactoryIsNull() {
        AsyncBatchDelivery.Builder batchDeliveryBuilder = BatchDeliveryTest.createTestBatchDeliveryBuilder();
        batchDeliveryBuilder.withClientObjectFactory(null);
        batchDeliveryBuilder.build();
    }

    @Test
    public void builderConfiguresShutdownDelayMillis() {
        long expectedShutdownDelayMillis = 10 + new Random().nextInt(100);
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy((Object)new TestFailoverPolicy());
        AsyncBatchDelivery.Builder batchDeliveryBuilder = BatchDeliveryTest.createTestBatchDeliveryBuilder().withFailoverPolicy(failoverPolicy).withShutdownDelayMillis(expectedShutdownDelayMillis);
        AsyncBatchDelivery asyncBatchDelivery = batchDeliveryBuilder.build();
        asyncBatchDelivery.start();
        asyncBatchDelivery.stop();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.class);
        ((LifeCycle)Mockito.verify((Object)LifeCycle.of((Object)failoverPolicy))).stop(((Long)captor.capture()).longValue(), ArgumentMatchers.anyBoolean());
        Assert.assertEquals((Object)expectedShutdownDelayMillis, (Object)captor.getValue());
    }

    @Test
    public void batchDeliveryAddObjectDelegatesToProvidedBatchOperationsObjectApi() {
        AsyncBatchDelivery.Builder batchDeliveryBuilder = BatchDeliveryTest.createTestBatchDeliveryBuilder();
        ClientObjectFactory clientObjectFactory = (ClientObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        BatchOperations batchOperations = (BatchOperations)Mockito.spy((Object)clientObjectFactory.createBatchOperations());
        Mockito.when((Object)clientObjectFactory.createBatchOperations()).thenReturn((Object)batchOperations);
        batchDeliveryBuilder.withClientObjectFactory(clientObjectFactory);
        AsyncBatchDelivery batchDelivery = batchDeliveryBuilder.build();
        String indexName = UUID.randomUUID().toString();
        String logObject = UUID.randomUUID().toString();
        batchDelivery.add(indexName, (Object)logObject);
        ((BatchOperations)Mockito.verify((Object)batchOperations)).createBatchItem((String)Mockito.eq((Object)indexName), Mockito.eq((Object)logObject));
    }

    @Test
    public void batchDeliveryAddItemSourceDelegatesToProvidedBatchOperationsItemSourceApi() {
        AsyncBatchDelivery.Builder batchDeliveryBuilder = BatchDeliveryTest.createTestBatchDeliveryBuilder();
        ClientObjectFactory clientObjectFactory = (ClientObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        BatchOperations batchOperations = (BatchOperations)Mockito.spy((Object)clientObjectFactory.createBatchOperations());
        Mockito.when((Object)clientObjectFactory.createBatchOperations()).thenReturn((Object)batchOperations);
        batchDeliveryBuilder.withClientObjectFactory(clientObjectFactory);
        AsyncBatchDelivery batchDelivery = batchDeliveryBuilder.build();
        String indexName = UUID.randomUUID().toString();
        ItemSource itemSource = (ItemSource)Mockito.mock(ItemSource.class);
        batchDelivery.add(indexName, itemSource);
        ((BatchOperations)Mockito.verify((Object)batchOperations)).createBatchItem((String)Mockito.eq((Object)indexName), (ItemSource)Mockito.eq((Object)itemSource));
    }

    @Test
    public void deliveryAddsBatchItemToBatchEmitter() {
        TestHttpObjectFactory objectFactory = BatchDeliveryTest.createTestObjectFactoryBuilder().build();
        final TestBatchEmitterFactory batchEmitterFactory = (TestBatchEmitterFactory)((Object)Mockito.spy((Object)((Object)new TestBatchEmitterFactory())));
        BatchEmitter emitter = batchEmitterFactory.createInstance(100, 100, objectFactory, (FailoverPolicy)new NoopFailoverPolicy());
        TestAsyncBatchDelivery delivery = (TestAsyncBatchDelivery)((Object)Mockito.spy((Object)((Object)new TestAsyncBatchDelivery(100, 100, objectFactory, (FailoverPolicy)new NoopFailoverPolicy(), null){

            @Override
            protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
                return batchEmitterFactory;
            }
        })));
        String testMessage = "test message";
        delivery.add("testIndexName", testMessage);
        ArgumentCaptor captor = ArgumentCaptor.forClass(BulkEmitterTest.TestBatchItem.class);
        ((BatchEmitter)Mockito.verify((Object)emitter, (VerificationMode)Mockito.times((int)1))).add(captor.capture());
        Assert.assertEquals((Object)testMessage, (Object)((BulkEmitterTest.TestBatchItem)captor.getValue()).getData(null));
    }

    @Test
    public void lifecycleStartSetsUpIndexTemplateExecutionIfIndexTemplateIsConfigured() {
        TestHttpObjectFactory objectFactory = (TestHttpObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        IndexTemplate indexTemplate = (IndexTemplate)Mockito.mock(IndexTemplate.class);
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withClientObjectFactory((ClientObjectFactory)objectFactory).withIndexTemplate(indexTemplate).build();
        batchDelivery.start();
        ((TestHttpObjectFactory)Mockito.verify((Object)objectFactory)).addOperation((Operation)Matchers.any());
    }

    @Test
    public void lifecycleStartDoesntSetUpIndexTemplateExecutionIfIndexTemplateIsNotConfigured() {
        TestHttpObjectFactory objectFactory = (TestHttpObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withClientObjectFactory((ClientObjectFactory)objectFactory).withIndexTemplate(null).build();
        batchDelivery.start();
        ((TestHttpObjectFactory)Mockito.verify((Object)objectFactory, (VerificationMode)Mockito.never())).addOperation((Operation)Matchers.any());
    }

    @Test
    public void failoverListenerDelegatesToBatchDelivery() {
        AsyncBatchDelivery batchDelivery = (AsyncBatchDelivery)Mockito.spy((Object)BatchDeliveryTest.createTestBatchDeliveryBuilder().build());
        FailoverListener listener = batchDelivery.failoverListener();
        FailedItemInfo failedItemInfo = (FailedItemInfo)Mockito.mock(FailedItemInfo.class);
        String expectedTargetName = UUID.randomUUID().toString();
        Mockito.when((Object)failedItemInfo.getTargetName()).thenReturn((Object)expectedTargetName);
        FailedItemSource failedItemSource = (FailedItemSource)Mockito.mock(FailedItemSource.class);
        Mockito.when((Object)failedItemSource.getInfo()).thenReturn((Object)failedItemInfo);
        listener.notify((Object)failedItemSource);
        ((AsyncBatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)Mockito.eq((Object)expectedTargetName), (ItemSource)Mockito.eq((Object)failedItemSource));
    }

    @Test
    public void lifecycleStartSetsUpFailoverListenerIfFailoverPolicyIsNotStarted() {
        TestFailoverPolicy failoverPolicy = (TestFailoverPolicy)Mockito.spy((Object)new TestFailoverPolicy());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withFailoverPolicy((FailoverPolicy)failoverPolicy).build();
        batchDelivery.start();
        ((TestFailoverPolicy)Mockito.verify((Object)failoverPolicy)).addListener((FailoverListener)Matchers.any());
    }

    @Test
    public void lifecycleStartDoesNotSetUpFailoverListenerIfFailoverPolicyStarted() {
        TestFailoverPolicy failoverPolicy = (TestFailoverPolicy)Mockito.spy((Object)new TestFailoverPolicy());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withFailoverPolicy((FailoverPolicy)failoverPolicy).build();
        failoverPolicy.start();
        batchDelivery.start();
        ((TestFailoverPolicy)Mockito.verify((Object)failoverPolicy, (VerificationMode)Mockito.never())).addListener((FailoverListener)Matchers.any());
    }

    @Test
    public void lifecycleStartStartsBatchEmitter() {
        final BatchEmitter batchEmitter = (BatchEmitter)Mockito.mock(BatchEmitter.class);
        final TestBatchEmitterFactory batchEmitterFactory = new TestBatchEmitterFactory(){

            @Override
            public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
                return batchEmitter;
            }
        };
        TestAsyncBatchDelivery batchDelivery = (TestAsyncBatchDelivery)((Object)Mockito.spy((Object)((Object)new TestAsyncBatchDelivery(100, 100, BatchDeliveryTest.createTestObjectFactoryBuilder().build(), (FailoverPolicy)new NoopFailoverPolicy(), null){

            @Override
            protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
                return batchEmitterFactory;
            }
        })));
        batchDelivery.start();
        ((BatchEmitter)Mockito.verify((Object)batchEmitter)).start();
    }

    @Test
    public void lifecycleStopStopsBatchEmitterOnlyOnce() {
        final BatchEmitter batchEmitter = (BatchEmitter)Mockito.mock(BatchEmitter.class);
        Mockito.when((Object)batchEmitter.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        final TestBatchEmitterFactory batchEmitterFactory = new TestBatchEmitterFactory(){

            @Override
            public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
                return batchEmitter;
            }
        };
        TestAsyncBatchDelivery batchDelivery = (TestAsyncBatchDelivery)((Object)Mockito.spy((Object)((Object)new TestAsyncBatchDelivery(100, 100, BatchDeliveryTest.createTestObjectFactoryBuilder().build(), (FailoverPolicy)new NoopFailoverPolicy(), null){

            @Override
            protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
                return batchEmitterFactory;
            }
        })));
        batchDelivery.stop();
        batchDelivery.stop();
        ((BatchEmitter)Mockito.verify((Object)batchEmitter)).stop(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void lifecycleStartStartsObjectFactoryOnlyOnce() {
        TestHttpObjectFactory objectFactory = (TestHttpObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        Mockito.when((Object)objectFactory.isStarted()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withClientObjectFactory((ClientObjectFactory)objectFactory).build();
        batchDelivery.start();
        batchDelivery.start();
        ((TestHttpObjectFactory)Mockito.verify((Object)objectFactory)).start();
    }

    @Test
    public void lifecycleStopStopsObjectFactoryOnlyOnce() {
        TestHttpObjectFactory objectFactory = (TestHttpObjectFactory)Mockito.spy((Object)BatchDeliveryTest.createTestObjectFactoryBuilder().build());
        Mockito.when((Object)objectFactory.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withClientObjectFactory((ClientObjectFactory)objectFactory).build();
        batchDelivery.stop();
        batchDelivery.stop();
        ((TestHttpObjectFactory)Mockito.verify((Object)objectFactory)).stop();
    }

    @Test
    public void lifecycleStartStartsFailoverPolicyOnlyOnce() {
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy((Object)new TestFailoverPolicy());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withFailoverPolicy(failoverPolicy).build();
        batchDelivery.start();
        batchDelivery.start();
        ((LifeCycle)Mockito.verify((Object)LifeCycle.of((Object)failoverPolicy))).start();
    }

    @Test
    public void lifecycleStopStopsFailoverPolicyOnlyOnce() {
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy((Object)new TestFailoverPolicy());
        AsyncBatchDelivery batchDelivery = BatchDeliveryTest.createTestBatchDeliveryBuilder().withFailoverPolicy(failoverPolicy).withShutdownDelayMillis(0L).build();
        batchDelivery.start();
        batchDelivery.stop();
        batchDelivery.stop();
        ((LifeCycle)Mockito.verify((Object)LifeCycle.of((Object)failoverPolicy))).stop(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return BatchDeliveryTest.createTestBatchDeliveryBuilder().withShutdownDelayMillis(0L).build();
    }

    private class TestFailoverPolicy
    implements FailoverPolicy,
    LifeCycle {
        private LifeCycle.State state = LifeCycle.State.STOPPED;

        private TestFailoverPolicy() {
        }

        public void deliver(Object failedPayload) {
        }

        public void start() {
            this.state = LifeCycle.State.STARTED;
        }

        public void stop() {
            this.state = LifeCycle.State.STOPPED;
        }

        public LifeCycle stop(long timeout, boolean runInBackground) {
            this.state = LifeCycle.State.STOPPED;
            return this;
        }

        public boolean isStarted() {
            return this.state == LifeCycle.State.STARTED;
        }

        public boolean isStopped() {
            return this.state == LifeCycle.State.STOPPED;
        }
    }

    static class TestAsyncBatchDelivery
    extends AsyncBatchDelivery {
        private BatchEmitterServiceProvider mockedProvider;

        public TestAsyncBatchDelivery(int batchSize, int deliveryInterval, ClientObjectFactory objectFactory, FailoverPolicy failoverPolicy, IndexTemplate indexTemplate) {
            super(batchSize, deliveryInterval, objectFactory, failoverPolicy, indexTemplate);
        }

        protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
            return this.mockedProvider;
        }
    }
}

