/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.AppenderRefFailoverPolicyTest;
import org.appenders.log4j2.elasticsearch.BatchDeliveryTest;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.TestBatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceLoader.class, BatchEmitterServiceProvider.class})
public class BatchEmitterServiceProviderTest {
    @Mock
    private ServiceLoader<BatchEmitterFactory> mockServiceLoader;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        PowerMockito.mockStatic(ServiceLoader.class, (Class[])new Class[0]);
        Mockito.when(ServiceLoader.load((Class)ArgumentMatchers.any(Class.class), (ClassLoader)ArgumentMatchers.any(ClassLoader.class))).thenReturn(this.mockServiceLoader);
    }

    @Test
    public void throwsExceptionWhenNoServiceWasFound() {
        BatchEmitterServiceProvider serviceProvider = (BatchEmitterServiceProvider)PowerMockito.spy((Object)new BatchEmitterServiceProvider());
        Iterator iterator = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)iterator.hasNext()).thenReturn((Object)false);
        Mockito.when(this.mockServiceLoader.iterator()).thenReturn((Object)iterator);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No compatible BatchEmitter implementations");
        serviceProvider.createInstance(2, 10000, (ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build(), AppenderRefFailoverPolicyTest.createTestFailoverPolicy("testRefAppender", (Configuration)Mockito.mock(Configuration.class)));
    }

    @Test
    public void succeedsWhenCompatibleFactoryWasFound() {
        BatchEmitterServiceProvider serviceProvider = (BatchEmitterServiceProvider)PowerMockito.spy((Object)new BatchEmitterServiceProvider());
        Iterator iterator = new ArrayList<BatchEmitterFactory>(){
            {
                this.add(new TestBatchEmitterFactory());
            }
        }.iterator();
        Mockito.when(this.mockServiceLoader.iterator()).thenReturn(iterator);
        BatchEmitter emitter = this.createWithTestValues(serviceProvider);
        Assert.assertNotNull((Object)emitter);
    }

    @Test
    public void throwsWhenFoundFactoryWasIncompatible() {
        BatchEmitterServiceProvider serviceProvider = (BatchEmitterServiceProvider)PowerMockito.spy((Object)new BatchEmitterServiceProvider());
        final TestBatchEmitterFactory emitterFactory = (TestBatchEmitterFactory)((Object)Mockito.mock(TestBatchEmitterFactory.class));
        Iterator iterator = new ArrayList<BatchEmitterFactory>(){
            {
                this.add(emitterFactory);
            }
        }.iterator();
        Mockito.when(this.mockServiceLoader.iterator()).thenReturn(iterator);
        Mockito.when((Object)emitterFactory.accepts((Class)Matchers.any())).thenReturn((Object)false);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No compatible BatchEmitter implementations");
        this.createWithTestValues(serviceProvider);
    }

    private BatchEmitter createWithTestValues(BatchEmitterServiceProvider serviceProvider) {
        return serviceProvider.createInstance(2, 10000, (ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build(), AppenderRefFailoverPolicyTest.createTestFailoverPolicy("testRefAppender", (Configuration)Mockito.mock(Configuration.class)));
    }
}

