/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.DataOutput;
import java.io.IOException;
import org.appenders.log4j2.elasticsearch.DataOutputAsStreamDelegate;
import org.junit.Test;
import org.mockito.Mockito;

public class DataOutputAsStreamDelegateTest {
    @Test
    public void canReplaceDelegate() throws IOException {
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        DataOutputAsStreamDelegate dataOutputDelegate = new DataOutputAsStreamDelegate(dataOutput1);
        dataOutputDelegate.write(1);
        DataOutput dataOutput2 = (DataOutput)Mockito.mock(DataOutput.class);
        dataOutputDelegate.setDelegate(dataOutput2);
        dataOutputDelegate.write(1);
        ((DataOutput)Mockito.verify((Object)dataOutput1)).write(1);
        ((DataOutput)Mockito.verify((Object)dataOutput2)).write(1);
    }

    @Test
    public void writeIntDelegates() throws IOException {
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        DataOutputAsStreamDelegate dataOutputDelegate = new DataOutputAsStreamDelegate(dataOutput1);
        dataOutputDelegate.write(1);
        ((DataOutput)Mockito.verify((Object)dataOutput1)).write(1);
    }

    @Test
    public void writeBytesDelegate() throws IOException {
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        DataOutputAsStreamDelegate dataOutputDelegate = new DataOutputAsStreamDelegate(dataOutput1);
        byte[] bytes = new byte[]{1};
        dataOutputDelegate.write(bytes);
        ((DataOutput)Mockito.verify((Object)dataOutput1)).write(bytes);
    }

    @Test
    public void writeBytesWithOffsetDelegates() throws IOException {
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        DataOutputAsStreamDelegate dataOutputDelegate = new DataOutputAsStreamDelegate(dataOutput1);
        byte[] bytes = new byte[]{1};
        dataOutputDelegate.write(bytes, 2, bytes.length);
        ((DataOutput)Mockito.verify((Object)dataOutput1)).write(bytes, 2, bytes.length);
    }
}

