/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.UUID;
import java.util.function.Consumer;
import org.appenders.log4j2.elasticsearch.DelayedShutdown;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DelayedShutdownTest {
    @Test
    public void runsGivenTask() {
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        DelayedShutdown shutdown = new DelayedShutdown(task);
        shutdown.start(false);
        ((Runnable)Mockito.verify((Object)task)).run();
    }

    @Test
    public void canRunTaskAsynchronously() {
        Runnable onStartTask = (Runnable)Mockito.mock(Runnable.class);
        DelayedShutdown shutdown = new DelayedShutdown(onStartTask);
        shutdown.start(true);
        ((Runnable)Mockito.verify((Object)onStartTask, (VerificationMode)Mockito.times((int)0))).run();
        ((Runnable)Mockito.verify((Object)onStartTask, (VerificationMode)Mockito.timeout((long)5000L).times(1))).run();
    }

    @Test
    public void delaysExecutionOfDelayedTask() {
        Runnable delayedTask = (Runnable)Mockito.mock(Runnable.class);
        DelayedShutdown shutdown = this.createDefaultDelayedShutdown().afterDelay(delayedTask).delay(100L);
        shutdown.start(true);
        ((Runnable)Mockito.verify((Object)delayedTask, (VerificationMode)Mockito.times((int)0))).run();
        ((Runnable)Mockito.verify((Object)delayedTask, (VerificationMode)Mockito.timeout((long)5000L).times(1))).run();
    }

    @Test
    public void runsDelayedTask() {
        Runnable delayedTask = (Runnable)Mockito.mock(Runnable.class);
        DelayedShutdown shutdown = this.createDefaultDelayedShutdown();
        shutdown.afterDelay(delayedTask);
        shutdown.start(false);
        ((Runnable)Mockito.verify((Object)delayedTask)).run();
    }

    @Test
    public void doesNotDelayTaskByDefault() {
        Consumer onDecrement = (Consumer)Mockito.mock(Consumer.class);
        DelayedShutdown shutdown = this.createDefaultDelayedShutdown().onDecrement(onDecrement);
        shutdown.start(false);
        ((Consumer)Mockito.verify((Object)onDecrement, (VerificationMode)Mockito.times((int)0))).accept(ArgumentMatchers.any());
    }

    @Test
    public void canRunIntermediateTasks() {
        Consumer onDecrement = (Consumer)Mockito.mock(Consumer.class);
        DelayedShutdown shutdown = this.createDefaultDelayedShutdown().decrementInMillis(10).delay(10L).onDecrement(onDecrement);
        shutdown.start(false);
        ((Consumer)Mockito.verify((Object)onDecrement, (VerificationMode)Mockito.times((int)1))).accept(ArgumentMatchers.any());
    }

    @Test
    public void runsDelayedTaskWithNoDecrementIfOnStartTaskTookLongerThanDelay() {
        Runnable delayedTask = (Runnable)Mockito.mock(Runnable.class);
        Consumer notExpectedTask = (Consumer)Mockito.mock(Consumer.class);
        long delay = 10L;
        Runnable longRunningTask = () -> this.justSleep(100);
        DelayedShutdown shutdown = new DelayedShutdown(longRunningTask).delay(delay).onDecrement(notExpectedTask).afterDelay(delayedTask);
        shutdown.start(false);
        ((Consumer)Mockito.verify((Object)notExpectedTask, (VerificationMode)Mockito.times((int)0))).accept(ArgumentMatchers.any());
        ((Runnable)Mockito.verify((Object)delayedTask, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void handlesInterruptedExceptions() {
        Consumer onError = (Consumer)Mockito.mock(Consumer.class);
        DelayedShutdown shutdown = this.createDefaultDelayedShutdown().delay(1000L).onError(onError);
        shutdown.start(true);
        new Thread(() -> shutdown.interrupt()).run();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Exception.class);
        ((Consumer)Mockito.verify((Object)onError, (VerificationMode)Mockito.timeout((long)1000L).times(1))).accept(captor.capture());
        Assert.assertTrue((boolean)(captor.getValue() instanceof InterruptedException));
    }

    @Test
    public void handlesExceptions() {
        Consumer onError = (Consumer)Mockito.mock(Consumer.class);
        String expectedMessage = UUID.randomUUID().toString();
        DelayedShutdown shutdown = new DelayedShutdown(() -> {
            throw new NullPointerException(expectedMessage);
        }).delay(1000L).onError(onError);
        shutdown.start(true);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Exception.class);
        ((Consumer)Mockito.verify((Object)onError, (VerificationMode)Mockito.timeout((long)1000L).times(1))).accept(captor.capture());
        Assert.assertEquals((Object)expectedMessage, (Object)((Exception)captor.getValue()).getMessage());
    }

    @Test
    public void exceptionsAreNotRethrown() {
        String expectedMessage = UUID.randomUUID().toString();
        DelayedShutdown shutdown = new DelayedShutdown(() -> {
            throw new NullPointerException(expectedMessage);
        });
        shutdown.start(false);
    }

    private void justSleep(int sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public DelayedShutdown createDefaultDelayedShutdown() {
        return new DelayedShutdown(() -> {});
    }
}

