/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ExtendedObjectWriter;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedObjectMapperTest {
    @Test
    public void newWriterWithNoArgsReturnsExtendedObjectWriter() {
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ObjectWriter writer = mapper.writer();
        Assert.assertEquals(ExtendedObjectWriter.class, writer.getClass());
    }

    @Test
    public void newWriterReturnsExtendedObjectWriter() {
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ObjectWriter writer = mapper.writerFor(Object.class);
        Assert.assertEquals(ExtendedObjectWriter.class, writer.getClass());
    }

    @Test
    public void newWriterWithPrettyPrinterReturnsExtendedObjectWriter() {
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ObjectWriter writer = mapper.writer((PrettyPrinter)new MinimalPrettyPrinter());
        Assert.assertEquals(ExtendedObjectWriter.class, writer.getClass());
    }

    @Test
    public void newWriterWithFormatSchemaReturnsExtendedObjectWriter() {
        ExtendedObjectMapper mapper = new ExtendedObjectMapper(new JsonFactory());
        ObjectWriter writer = mapper.writer(() -> "JSON");
        Assert.assertEquals(ExtendedObjectWriter.class, writer.getClass());
    }
}

