/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.File;
import java.util.UUID;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class IndexTemplateTest {
    public static final String TEST_INDEX_TEMPLATE = "testIndexTemplate";
    public static final String TEST_PATH = "classpath:indexTemplate.json";
    private static final String TEST_SOURCE = "{}";

    public static IndexTemplate.Builder createTestIndexTemplateBuilder() {
        IndexTemplate.Builder builder = IndexTemplate.newBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(TEST_PATH);
        return builder;
    }

    @Test
    public void startsWhenSetupCorrectlyWithNameAndPath() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(TEST_PATH);
        IndexTemplate indexTemplate = builder.build();
        Assert.assertNotNull((Object)indexTemplate);
        Assert.assertNotNull((Object)indexTemplate.getName());
        Assert.assertNotNull((Object)indexTemplate.getSource());
    }

    @Test
    public void startsWhenSetupCorrectlyWithNameAndSource() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(TEST_INDEX_TEMPLATE).withPath(null).withSource(TEST_SOURCE);
        IndexTemplate indexTemplate = builder.build();
        Assert.assertNotNull((Object)indexTemplate);
        Assert.assertNotNull((Object)indexTemplate.getName());
        Assert.assertNotNull((Object)indexTemplate.getSource());
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenNameIsNotSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withName(null);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenNeitherPathOrSourceIsSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(null).withSource(null);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenBothPathAndSourceAreSet() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(TEST_PATH).withSource(TEST_SOURCE);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenClasspathResourceDoesntExist() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("classpath:nonExistentFile");
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionWhenFileDoesntExist() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("nonExistentFile");
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptionOnInvalidProtocol() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath("~/nonExistentFile");
        builder.build();
    }

    @Test
    public void builderDoesntThrowExceptionWhenFileExists() {
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder();
        builder.withPath(new File(ClassLoader.getSystemClassLoader().getResource("indexTemplate.json").getFile()).getAbsolutePath());
        builder.build();
    }

    @Test
    public void builderResolvesSourceWithValueResolverIfProvided() {
        String var1Name = UUID.randomUUID().toString();
        String var1Value = UUID.randomUUID().toString();
        String var2Name = UUID.randomUUID().toString();
        String var2Value = UUID.randomUUID().toString();
        System.setProperty(var1Name, var1Value);
        System.setProperty(var2Name, var2Value);
        String expected = String.format("{\n\t\"%s: \"%s\",\n\t\"%s: \"%s\"}", var1Name, var1Value, var2Name, var2Value);
        String source = String.format("{\n\t\"%s: \"%s\",\n\t\"%s: \"%s\"}", var1Name, String.format("${sys:%s}", var1Name), var2Name, String.format("${sys:%s}", var2Name));
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder().withPath(null).withSource(source).withValueResolver((ValueResolver)this.defaultTestValueResolver());
        IndexTemplate template = builder.build();
        Assert.assertEquals((Object)expected, (Object)template.getSource());
    }

    @Test
    public void builderResolvesSourceIfValueResolverNotProvidedAndConfigurationProvided() {
        String var1Name = UUID.randomUUID().toString();
        String var1Value = UUID.randomUUID().toString();
        String var2Name = UUID.randomUUID().toString();
        String var2Value = UUID.randomUUID().toString();
        System.setProperty(var1Name, var1Value);
        System.setProperty(var2Name, var2Value);
        String expected = String.format("{\n\t\"%s: \"%s\",\n\t\"%s: \"%s\"}", var1Name, var1Value, var2Name, var2Value);
        String source = String.format("{\n\t\"%s: \"%s\",\n\t\"%s: \"%s\"}", var1Name, String.format("${sys:%s}", var1Name), var2Name, String.format("${sys:%s}", var2Name));
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder().withPath(null).withSource(source).withConfiguration(LoggerContext.getContext((boolean)false).getConfiguration());
        IndexTemplate template = builder.build();
        Assert.assertEquals((Object)expected, (Object)template.getSource());
    }

    @Test
    public void builderResolvesSourceWithNoopResolverIfValueResolverNotProvidedAndConfigurationNotProvided() {
        String var1Name = UUID.randomUUID().toString();
        String var1Value = UUID.randomUUID().toString();
        String var2Name = UUID.randomUUID().toString();
        String var2Value = UUID.randomUUID().toString();
        System.setProperty(var1Name, var1Value);
        System.setProperty(var2Name, var2Value);
        String source = String.format("{\n\t\"%s: \"%s\",\n\t\"%s: \"%s\"}", var1Name, String.format("${sys:%s}", var1Name), var2Name, String.format("${sys:%s}", var2Name));
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder().withPath(null).withSource(source).withConfiguration(null).withValueResolver(null);
        IndexTemplate template = builder.build();
        Assert.assertEquals((Object)source, (Object)template.getSource());
    }

    @Test
    public void builderNoopResolverDoesntNotResolveVirtualProperty() {
        String var1Name = UUID.randomUUID().toString();
        String var1Value = UUID.randomUUID().toString();
        String var2Name = UUID.randomUUID().toString();
        String var2Value = UUID.randomUUID().toString();
        System.setProperty(var1Name, var1Value);
        System.setProperty(var2Name, var2Value);
        IndexTemplate.Builder builder = IndexTemplateTest.createTestIndexTemplateBuilder().withPath(null).withSource(TEST_SOURCE).withConfiguration(null).withValueResolver(null);
        ValueResolver resolver = builder.getValueResolver();
        VirtualProperty virtualProperty = new VirtualProperty(var1Name, String.format("${sys:%s}", var1Name), false);
        String result = resolver.resolve(virtualProperty);
        Assert.assertEquals((Object)String.format("${sys:%s}", var1Name), (Object)result);
    }

    @NotNull
    public Log4j2Lookup defaultTestValueResolver() {
        return new Log4j2Lookup(new StrSubstitutor((StrLookup)new Interpolator()));
    }
}

