/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.message.Message;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemAppenderFactory;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceAppender;
import org.appenders.log4j2.elasticsearch.ItemSourceLayout;
import org.appenders.log4j2.elasticsearch.StringAppender;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ItemAppenderFactoryTest {
    @Captor
    private ArgumentCaptor<String> indexNameCaptor;
    @Captor
    private ArgumentCaptor<LogEvent> logEventCaptor;
    @Captor
    private ArgumentCaptor<Message> messageCaptor;
    @Captor
    private ArgumentCaptor<String> stringLogCaptor;
    @Captor
    private ArgumentCaptor<ItemSource> itemSourceCaptor;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void messageOnlyLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        Layout Layout2 = (Layout)Mockito.mock(Layout.class);
        ItemAppender itemAppender = factory.createInstance(true, Layout2, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)message.getFormattedMessage()).thenReturn((Object)expectedMessage);
        Mockito.when((Object)logEvent.getMessage()).thenReturn((Object)message);
        itemAppender.append(formattedIndexName, (Object)logEvent);
        Assert.assertTrue((boolean)(itemAppender instanceof StringAppender));
        ((Layout)Mockito.verify((Object)Layout2, (VerificationMode)Mockito.never())).toSerializable((LogEvent)Matchers.any());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), this.stringLogCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)this.stringLogCaptor.getValue());
    }

    @Test
    public void nonMessageOnlyLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        Layout stringBasedLayout = (Layout)Mockito.mock(Layout.class);
        ItemAppender itemAppender = factory.createInstance(false, stringBasedLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        Mockito.when((Object)stringBasedLayout.toSerializable((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)expectedMessage);
        LogEvent logEvent = this.createDefaultTestLogEvent();
        itemAppender.append(formattedIndexName, (Object)logEvent);
        Assert.assertTrue((boolean)(itemAppender instanceof StringAppender));
        ((Layout)Mockito.verify((Object)stringBasedLayout)).toSerializable((LogEvent)this.logEventCaptor.capture());
        Assert.assertEquals((Object)logEvent, (Object)this.logEventCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), this.stringLogCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)this.stringLogCaptor.getValue());
    }

    @Test
    public void givenAnyLayoutImplementingItemSourceLayoutDelegatesToItemSourceLayoutFactoryMethod() {
        ItemAppenderFactory factory = (ItemAppenderFactory)Mockito.spy((Object)new ItemAppenderFactory());
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)new TestItemSourceLayout());
        factory.createInstance(false, itemSourceLayout, batchDelivery);
        ((ItemAppenderFactory)Mockito.verify((Object)factory)).createInstance(Matchers.eq((boolean)false), (ItemSourceLayout)Matchers.eq((Object)itemSourceLayout), (BatchDelivery)Matchers.eq((Object)batchDelivery));
    }

    @Test
    public void nonMessageOnlyItemSourceLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)new TestItemSourceLayout());
        ItemSourceAppender itemAppender = factory.createInstance(false, itemSourceLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        StringItemSource itemSource = new StringItemSource(expectedMessage);
        Mockito.when((Object)itemSourceLayout.serialize((LogEvent)Matchers.any(LogEvent.class))).thenReturn((Object)itemSource);
        LogEvent logEvent = this.createDefaultTestLogEvent();
        itemAppender.append(formattedIndexName, logEvent);
        Assert.assertEquals(ItemSourceAppender.class, itemAppender.getClass());
        ((ItemSourceLayout)Mockito.verify((Object)itemSourceLayout)).serialize((LogEvent)this.logEventCaptor.capture());
        Assert.assertEquals((Object)logEvent, (Object)this.logEventCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), (ItemSource)this.itemSourceCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)((ItemSource)this.itemSourceCaptor.getValue()).getSource());
    }

    @Test
    public void messageOnlyItemSourceLayout() {
        ItemAppenderFactory factory = new ItemAppenderFactory();
        String formattedIndexName = UUID.randomUUID().toString();
        BatchDelivery batchDelivery = (BatchDelivery)Mockito.mock(BatchDelivery.class);
        ItemSourceLayout itemSourceLayout = (ItemSourceLayout)Mockito.spy((Object)new TestItemSourceLayout());
        ItemSourceAppender itemAppender = factory.createInstance(true, itemSourceLayout, batchDelivery);
        String expectedMessage = UUID.randomUUID().toString();
        StringItemSource itemSource = new StringItemSource(expectedMessage);
        Mockito.when((Object)itemSourceLayout.serialize((Message)Matchers.any(Message.class))).thenReturn((Object)itemSource);
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)logEvent.getMessage()).thenReturn((Object)message);
        itemAppender.append(formattedIndexName, logEvent);
        Assert.assertEquals(ItemSourceAppender.class, itemAppender.getClass());
        ((ItemSourceLayout)Mockito.verify((Object)itemSourceLayout)).serialize((Message)this.messageCaptor.capture());
        Assert.assertEquals((Object)message, (Object)this.messageCaptor.getValue());
        ((BatchDelivery)Mockito.verify((Object)batchDelivery)).add((String)this.indexNameCaptor.capture(), (ItemSource)this.itemSourceCaptor.capture());
        Assert.assertEquals((Object)formattedIndexName, (Object)this.indexNameCaptor.getValue());
        Assert.assertEquals((Object)expectedMessage, (Object)((ItemSource)this.itemSourceCaptor.getValue()).getSource());
    }

    private LogEvent createDefaultTestLogEvent() {
        return (LogEvent)Mockito.mock(LogEvent.class);
    }

    private class TestItemSourceLayout
    implements ItemSourceLayout,
    Layout {
        private TestItemSourceLayout() {
        }

        public byte[] getFooter() {
            return new byte[0];
        }

        public byte[] getHeader() {
            return new byte[0];
        }

        public byte[] toByteArray(LogEvent event) {
            return new byte[0];
        }

        public Serializable toSerializable(LogEvent event) {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Map<String, String> getContentFormat() {
            return null;
        }

        public void encode(Object source, ByteBufferDestination destination) {
        }

        public ItemSource serialize(LogEvent event) {
            return null;
        }

        public ItemSource serialize(Message message) {
            return null;
        }
    }
}

