/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.appenders.log4j2.elasticsearch.JacksonHandlerInstantiator;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualPropertiesWriter;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JacksonHandlerInstantiatorTest {
    @Test
    public void startsWithNoErrors() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        JacksonHandlerInstantiator result = this.createTestHandlerInstantiator(customProperties, valueResolver);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void virtualPropertyWriterInstanceReturnsSingleton() {
        VirtualPropertiesWriter result2;
        SerializationConfig config;
        VirtualProperty[] customProperties = new VirtualProperty[0];
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        VirtualPropertiesWriter result1 = handlerInstantiator.virtualPropertyWriterInstance((MapperConfig)(config = new ObjectMapper().getSerializationConfig()), VirtualPropertiesWriter.class);
        Assert.assertTrue((result1 == (result2 = handlerInstantiator.virtualPropertyWriterInstance((MapperConfig)config, VirtualPropertiesWriter.class)) ? 1 : 0) != 0);
    }

    @Test
    public void deserializerInstanceReturnsNull() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        JsonDeserializer result = handlerInstantiator.deserializerInstance(null, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void keyDeserializerInstanceReturnsNull() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        KeyDeserializer result = handlerInstantiator.keyDeserializerInstance(null, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void serializerInstanceReturnsNull() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        JsonSerializer result = handlerInstantiator.serializerInstance(null, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void typeResolverBuilderInstanceReturnsNull() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        TypeResolverBuilder result = handlerInstantiator.typeResolverBuilderInstance(null, null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void typeIdResolverInstanceReturnsNull() {
        VirtualProperty[] customProperties = new VirtualProperty[]{};
        Log4j2Lookup valueResolver = new Log4j2Lookup(null);
        JacksonHandlerInstantiator handlerInstantiator = this.createTestHandlerInstantiator(customProperties, (ValueResolver)valueResolver);
        TypeIdResolver result = handlerInstantiator.typeIdResolverInstance(null, null, null);
        Assert.assertNull((Object)result);
    }

    private JacksonHandlerInstantiator createTestHandlerInstantiator(VirtualProperty[] customProperties, ValueResolver valueResolver) {
        return new JacksonHandlerInstantiator(customProperties, valueResolver);
    }
}

