/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.ExtendedLog4j2JsonModule;
import org.apache.logging.log4j.core.jackson.LogEventJacksonJsonMixIn;
import org.apache.logging.log4j.message.Message;
import org.appenders.log4j2.elasticsearch.ExtendedObjectWriter;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.JacksonHandlerInstantiator;
import org.appenders.log4j2.elasticsearch.JacksonJsonLayout;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.appenders.log4j2.elasticsearch.JacksonMixInTest;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.SingleThreadJsonFactory;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.appenders.log4j2.elasticsearch.StringItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.appenders.log4j2.elasticsearch.VirtualPropertyFilter;
import org.appenders.log4j2.elasticsearch.mock.LifecycleTestHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JacksonJsonLayoutTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builderBuildsSuccessfully() {
        JacksonJsonLayout.Builder builder = this.createDefaultTestBuilder();
        JacksonJsonLayout layout = builder.build();
        Assert.assertNotNull((Object)layout);
    }

    @Test
    public void contentTypeIsNotNull() {
        JacksonJsonLayout layout = this.createDefaultTestBuilder().build();
        String contentType = layout.getContentType();
        Assert.assertNotNull((Object)contentType);
    }

    @Test
    public void throwsOnByteArrayCreationAttempt() {
        JacksonJsonLayout layout = this.createDefaultTestBuilder().build();
        this.expectedException.expect(UnsupportedOperationException.class);
        layout.toByteArray((LogEvent)new Log4jLogEvent());
    }

    @Test
    public void throwsOnNullConfiguration() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)this.createDefaultTestBuilder().setConfiguration(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No Configuration instance provided for JacksonJsonLayout");
        builder.build();
    }

    @Test
    public void builderBuildsLayoutWithDefaultItemSourceFactoryIfNotConfigured() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        JacksonJsonLayout layout = builder.build();
        Log4jLogEvent logEvent = new Log4jLogEvent();
        ItemSource itemSource = layout.toSerializable((LogEvent)logEvent);
        Assert.assertEquals(StringItemSource.class, itemSource.getClass());
    }

    @Test
    public void builderBuildsLayoutWithProvidedItemSourceFactoryIfConfigured() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.withItemSourceFactory((ItemSourceFactory)new LayoutTestItemSourceFactory());
        JacksonJsonLayout layout = builder.build();
        Log4jLogEvent logEvent = new Log4jLogEvent();
        ItemSource itemSource = layout.toSerializable((LogEvent)logEvent);
        Assert.assertEquals(LayoutTestItemSource.class, itemSource.getClass());
    }

    @Test
    public void builderBuildsMapperWithAfterburnerIfConfigured() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.withAfterburner(true);
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy((Object)new ObjectMapper());
        Mockito.when((Object)builder.createDefaultObjectMapper()).thenReturn((Object)objectMapper);
        builder.build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Module.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper, (VerificationMode)Mockito.atLeastOnce())).registerModule((Module)captor.capture());
        Assert.assertThat((Object)captor.getAllValues(), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.instanceOf(AfterburnerModule.class)));
    }

    @Test
    public void builderBuildsMapperWithMixInsIfConfigured() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.withMixins(new JacksonMixIn[]{JacksonMixInTest.createDefaultTestBuilder().build()});
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy(ObjectMapper.class);
        Mockito.when((Object)builder.createDefaultObjectMapper()).thenReturn((Object)objectMapper);
        builder.build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ExtendedLog4j2JsonModule.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).registerModule((Module)captor.capture());
        Module.SetupContext setupContext = (Module.SetupContext)Mockito.mock(Module.SetupContext.class);
        ((ExtendedLog4j2JsonModule)captor.getValue()).setupModule(setupContext);
        ((Module.SetupContext)Mockito.verify((Object)setupContext)).setMixInAnnotations((Class)Matchers.eq(LogEvent.class), (Class)Matchers.eq(LogEventJacksonJsonMixIn.class));
    }

    @Test
    public void builderBuildsMapperWithCustomHandlerInstantiator() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        ObjectMapper objectMapper = (ObjectMapper)Mockito.spy(ObjectMapper.class);
        Mockito.when((Object)builder.createDefaultObjectMapper()).thenReturn((Object)objectMapper);
        builder.build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(SerializationConfig.class);
        ((ObjectMapper)Mockito.verify((Object)objectMapper)).setConfig((SerializationConfig)captor.capture());
        HandlerInstantiator handlerInstantiator = ((SerializationConfig)captor.getValue()).getHandlerInstantiator();
        Assert.assertTrue((boolean)(handlerInstantiator instanceof JacksonHandlerInstantiator));
    }

    @Test
    public void builderResolvesNonDynamicVirtualProperties() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        Mockito.when((Object)builder.createValueResolver()).thenReturn((Object)valueResolver);
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = new VirtualProperty.Builder().withDynamic(false).withName(UUID.randomUUID().toString()).withValue(expectedValue).build();
        builder.withVirtualProperties(new VirtualProperty[]{virtualProperty});
        builder.build();
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((ValueResolver)Mockito.verify((Object)valueResolver)).resolve((String)captor.capture());
        Assert.assertEquals((Object)expectedValue, (Object)captor.getValue());
    }

    @Test
    public void builderDoesNotUseFiltersWhileResolvingNonDynamicVirtualProperties() {
        VirtualPropertyFilter filter = (VirtualPropertyFilter)Mockito.mock(VirtualPropertyFilter.class);
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder().withVirtualPropertyFilters(new VirtualPropertyFilter[]{filter}));
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        Mockito.when((Object)builder.createValueResolver()).thenReturn((Object)valueResolver);
        VirtualProperty virtualProperty = new VirtualProperty.Builder().withDynamic(false).withName(UUID.randomUUID().toString()).withValue(UUID.randomUUID().toString()).build();
        builder.withVirtualProperties(new VirtualProperty[]{virtualProperty});
        builder.build();
        ((VirtualPropertyFilter)Mockito.verify((Object)filter, (VerificationMode)Mockito.never())).isIncluded((String)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void builderDoesNotResolveDynamicVirtualProperties() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        Mockito.when((Object)builder.createValueResolver()).thenReturn((Object)valueResolver);
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = new VirtualProperty.Builder().withDynamic(true).withName(UUID.randomUUID().toString()).withValue(expectedValue).build();
        builder.withVirtualProperties(new VirtualProperty[]{virtualProperty});
        builder.build();
        ((ValueResolver)Mockito.verify((Object)valueResolver, (VerificationMode)Mockito.never())).resolve(ArgumentMatchers.anyString());
    }

    @Test
    public void builderCreatesExtendedObjectWriter() {
        JacksonJsonLayout.Builder builder = this.createDefaultTestBuilder();
        ObjectWriter writer = builder.createConfiguredWriter(new ArrayList());
        Assert.assertEquals(ExtendedObjectWriter.class, writer.getClass());
    }

    @Test
    public void builderConfiguresExtendedObjectWriter() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.build();
        ((JacksonJsonLayout.Builder)Mockito.verify((Object)builder)).createConfiguredWriter((List)Matchers.any());
    }

    @Test
    public void builderCreatesLog4j2ValueResolver() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        ValueResolver result = builder.createValueResolver();
        Assert.assertTrue((boolean)(result instanceof Log4j2Lookup));
    }

    @Test
    public void createsSingleThreadJsonFactoryIfConfigured() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.withSingleThread(true);
        ObjectMapper defaultObjectMapper = builder.createDefaultObjectMapper();
        ((JacksonJsonLayout.Builder)Mockito.verify((Object)builder)).createJsonFactory();
        Assert.assertTrue((boolean)(defaultObjectMapper.getFactory() instanceof SingleThreadJsonFactory));
    }

    @Test
    public void createsJsonFactoryByDefault() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        builder.withSingleThread(false);
        ObjectMapper defaultObjectMapper = builder.createDefaultObjectMapper();
        ((JacksonJsonLayout.Builder)Mockito.verify((Object)builder)).createJsonFactory();
        Assert.assertEquals(defaultObjectMapper.getFactory().getClass(), JsonFactory.class);
    }

    private JacksonJsonLayout.Builder createDefaultTestBuilder() {
        return (JacksonJsonLayout.Builder)JacksonJsonLayout.newBuilder().setConfiguration(LoggerContext.getContext((boolean)false).getConfiguration());
    }

    @Test
    public void messageSerializationDelegatesToItemSourceFactory() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        LayoutTestItemSourceFactory itemSourceFactory = (LayoutTestItemSourceFactory)((Object)Mockito.spy((Object)((Object)new LayoutTestItemSourceFactory())));
        builder.withItemSourceFactory((ItemSourceFactory)itemSourceFactory);
        JacksonJsonLayout layout = builder.build();
        Log4jLogEvent logEvent = new Log4jLogEvent();
        Message message = logEvent.getMessage();
        layout.serialize(message);
        ((LayoutTestItemSourceFactory)((Object)Mockito.verify((Object)((Object)itemSourceFactory)))).create(Matchers.eq((Object)message), (ObjectWriter)Matchers.any(ObjectWriter.class));
    }

    @Test
    public void logEventSerializationDelegatesToItemSourceFactory() {
        JacksonJsonLayout.Builder builder = (JacksonJsonLayout.Builder)Mockito.spy((Object)this.createDefaultTestBuilder());
        LayoutTestItemSourceFactory itemSourceFactory = (LayoutTestItemSourceFactory)((Object)Mockito.spy((Object)((Object)new LayoutTestItemSourceFactory())));
        builder.withItemSourceFactory((ItemSourceFactory)itemSourceFactory);
        JacksonJsonLayout layout = builder.build();
        Log4jLogEvent logEvent = new Log4jLogEvent();
        layout.toSerializable((LogEvent)logEvent);
        ((LayoutTestItemSourceFactory)((Object)Mockito.verify((Object)((Object)itemSourceFactory)))).create(Matchers.eq((Object)logEvent), (ObjectWriter)Matchers.any(ObjectWriter.class));
    }

    @Test
    public void lifecycleStopStopsItemSourceFactoryOnlyOnce() {
        ItemSourceFactory itemSourceFactory = (ItemSourceFactory)Mockito.mock(ItemSourceFactory.class);
        Mockito.when((Object)itemSourceFactory.isStopped()).thenAnswer(LifecycleTestHelper.falseOnlyOnce());
        JacksonJsonLayout layout = this.createDefaultTestBuilder().withItemSourceFactory(itemSourceFactory).build();
        layout.stop();
        layout.stop();
        ((ItemSourceFactory)Mockito.verify((Object)itemSourceFactory)).stop();
    }

    @Test
    public void lifecycleStart() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertTrue((boolean)lifeCycle.isStopped());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    private LifeCycle createLifeCycleTestObject() {
        return this.createDefaultTestBuilder().build();
    }

    public static class LayoutTestItemSource
    extends StringItemSource {
        public LayoutTestItemSource(String source) {
            super(source);
        }
    }

    public static class LayoutTestItemSourceFactory
    extends StringItemSourceFactory {
        public ItemSource create(Object event, ObjectWriter objectWriter) {
            try {
                return new LayoutTestItemSource(objectWriter.writeValueAsString(event));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

