/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.LogEventJacksonJsonMixIn;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JacksonMixInTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public static JacksonMixIn.Builder createDefaultTestBuilder() {
        JacksonMixIn.Builder builder = JacksonMixIn.newBuilder();
        builder.withMixInClass(LogEventJacksonJsonMixIn.class.getName());
        builder.withTargetClass(Log4jLogEvent.class.getName());
        return builder;
    }

    @Test
    public void buiderSucceedsOnValidConfig() {
        JacksonMixIn.Builder builder = JacksonMixInTest.createDefaultTestBuilder();
        JacksonMixIn jacksonMixIn = builder.build();
        Assert.assertNotNull((Object)jacksonMixIn);
        Assert.assertEquals(Log4jLogEvent.class, (Object)jacksonMixIn.getTargetClass());
        Assert.assertEquals(LogEventJacksonJsonMixIn.class, (Object)jacksonMixIn.getMixInClass());
    }

    @Test
    public void builderThrowsOnNullTargetClass() {
        JacksonMixIn.Builder builder = JacksonMixInTest.createDefaultTestBuilder();
        builder.withTargetClass(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No targetClass provided for JacksonMixIn");
        builder.build();
    }

    @Test
    public void builderThrowsOnNullMixInClass() {
        JacksonMixIn.Builder builder = JacksonMixInTest.createDefaultTestBuilder();
        builder.withMixInClass(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No mixInClass provided for JacksonMixIn");
        builder.build();
    }

    @Test
    public void builderThrowsOnMixInClassNotFound() {
        JacksonMixIn.Builder builder = JacksonMixInTest.createDefaultTestBuilder();
        String mixInClass = "org.appenders.test.NonExistingClass";
        builder.withMixInClass(mixInClass);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Cannot load mixInClass");
        this.expectedException.expectMessage(mixInClass);
        builder.build();
    }

    @Test
    public void builderThrowsOnTargetClassNotFound() {
        JacksonMixIn.Builder builder = JacksonMixInTest.createDefaultTestBuilder();
        String targetClass = "org.appenders.test.NonExistingClass";
        builder.withTargetClass(targetClass);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Cannot load targetClass");
        this.expectedException.expectMessage(targetClass);
        builder.build();
    }
}

