/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LifeCycleTest {
    @Test
    public void returnsLifeCycleOfGivenObjectIfAvailable() {
        TestObject expected = LifeCycleTest.createDefaultTestLifecycle();
        LifeCycle lifeCycle = LifeCycle.of((Object)expected);
        Assert.assertEquals((Object)expected, (Object)lifeCycle);
    }

    @Test
    public void returnsNoopLifeCycleIfNonLifeCycleObject() {
        Object expected = new Object();
        LifeCycle lifeCycle = LifeCycle.of((Object)expected);
        Assert.assertNotEquals((Object)expected, (Object)lifeCycle);
        Assert.assertSame((Object)LifeCycle.NOOP, (Object)lifeCycle);
    }

    @Test
    public void stopDelegatesToParametrizedStop() {
        LifeCycle lifeCycle = (LifeCycle)Mockito.spy((Object)LifeCycleTest.createDefaultTestLifecycle());
        lifeCycle.stop();
        ((LifeCycle)Mockito.verify((Object)lifeCycle)).stop(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public static TestObject createDefaultTestLifecycle() {
        return new TestObject();
    }

    private static class TestObject
    implements LifeCycle {
        private TestObject() {
        }

        public void start() {
        }

        public boolean isStarted() {
            return false;
        }

        public boolean isStopped() {
            return false;
        }
    }
}

