/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.UUID;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.appenders.log4j2.elasticsearch.VirtualPropertyTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class Log4j2LookupTest {
    @Test
    public void startsSuccessfully() {
        StrSubstitutor strSubstitutor = this.createDefaultTestStrSubstitutor();
        Log4j2Lookup result = this.createDefaultTestLog4j2Lookup(strSubstitutor);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void resolvesDynamicPropertyOnEachCall() {
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withValue(expectedValue).withDynamic(true).build();
        StrSubstitutor strSubstitutor = (StrSubstitutor)Mockito.spy((Object)this.createDefaultTestStrSubstitutor());
        Log4j2Lookup lookup = this.createDefaultTestLog4j2Lookup(strSubstitutor);
        lookup.resolve(virtualProperty);
        lookup.resolve(virtualProperty);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((StrSubstitutor)Mockito.verify((Object)strSubstitutor, (VerificationMode)Mockito.times((int)2))).replace((String)captor.capture());
        Assert.assertEquals((Object)expectedValue, captor.getAllValues().get(0));
        Assert.assertEquals((Object)expectedValue, captor.getAllValues().get(1));
    }

    @Test
    public void resolvesDynamicPropertyDelegatesToStringBasedApi() {
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withValue(expectedValue).withDynamic(true).build();
        Log4j2Lookup lookup = (Log4j2Lookup)Mockito.spy((Object)this.createDefaultTestLog4j2Lookup(this.createDefaultTestStrSubstitutor()));
        lookup.resolve(virtualProperty);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((Log4j2Lookup)Mockito.verify((Object)lookup, (VerificationMode)Mockito.times((int)1))).resolve((String)captor.capture());
        Assert.assertEquals((Object)expectedValue, (Object)captor.getValue());
    }

    @Test
    public void doesNotResolveNonDynamicVirtualProperties() {
        VirtualProperty virtualProperty = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withDynamic(false).build();
        StrSubstitutor strSubstitutor = (StrSubstitutor)Mockito.spy((Object)this.createDefaultTestStrSubstitutor());
        Log4j2Lookup lookup = this.createDefaultTestLog4j2Lookup(strSubstitutor);
        lookup.resolve(virtualProperty);
        ((StrSubstitutor)Mockito.verify((Object)strSubstitutor, (VerificationMode)Mockito.never())).replace(ArgumentMatchers.anyString());
    }

    private Log4j2Lookup createDefaultTestLog4j2Lookup(StrSubstitutor strSubstitutor) {
        return new Log4j2Lookup(strSubstitutor);
    }

    private StrSubstitutor createDefaultTestStrSubstitutor() {
        return LoggerContext.getContext((boolean)false).getConfiguration().getStrSubstitutor();
    }
}

