/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class NoopFailoverPolicyTest {
    @Test
    public void minimalBuilderTest() {
        NoopFailoverPolicy.Builder builder = NoopFailoverPolicy.newBuilder();
        NoopFailoverPolicy failoverPolicy = builder.build();
        Assert.assertNotNull((Object)failoverPolicy);
    }

    @Test
    public void deliverItemSourceDelegatesToGenericAPI() {
        NoopFailoverPolicy.Builder builder = NoopFailoverPolicy.newBuilder();
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy((Object)builder.build());
        ItemSource failedItemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        Object itemSource = Mockito.mock(ItemSource.class);
        Mockito.when((Object)failedItemSource.getSource()).thenReturn(itemSource);
        failoverPolicy.deliver(failedItemSource);
        ((FailoverPolicy)Mockito.verify((Object)failoverPolicy)).deliver(itemSource);
    }

    @Test
    public void deliverFailedItemSourceDelegatesToGenericAPI() {
        NoopFailoverPolicy.Builder builder = NoopFailoverPolicy.newBuilder();
        FailoverPolicy failoverPolicy = (FailoverPolicy)Mockito.spy((Object)builder.build());
        FailedItemSource failedItemSource = (FailedItemSource)Mockito.mock(FailedItemSource.class);
        Object itemSource = Mockito.mock(ItemSource.class);
        Mockito.when((Object)failedItemSource.getSource()).thenReturn(itemSource);
        failoverPolicy.deliver(failedItemSource);
        ((FailoverPolicy)Mockito.verify((Object)failoverPolicy)).deliver((ItemSource)failedItemSource);
        ((FailoverPolicy)Mockito.verify((Object)failoverPolicy)).deliver(itemSource);
    }
}

