/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.NoopIndexNameFormatter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class NoopIndexNameFormatterTest {
    public static final String TEST_INDEX_NAME = "testIndexName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void returnsIndexNameUnchanged() {
        NoopIndexNameFormatter.Builder builder = NoopIndexNameFormatter.newBuilder();
        builder.withIndexName(TEST_INDEX_NAME);
        NoopIndexNameFormatter formatter = builder.build();
        String formattedIndexName = formatter.format((LogEvent)Mockito.mock(LogEvent.class));
        Assert.assertEquals((Object)TEST_INDEX_NAME, (Object)formattedIndexName);
    }

    @Test
    public void builderThrowsWhenNameIsNull() {
        NoopIndexNameFormatter.Builder builder = NoopIndexNameFormatter.newBuilder();
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("indexName");
        builder.build();
    }
}

