/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.IOException;
import java.io.OutputStream;
import org.appenders.log4j2.elasticsearch.OutputStreamDelegate;
import org.junit.Test;
import org.mockito.Mockito;

public class OutputStreamDelegateTest {
    @Test
    public void canReplaceDelegate() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate outputStreamDelegate = new OutputStreamDelegate(os1);
        outputStreamDelegate.write(1);
        OutputStream os2 = (OutputStream)Mockito.mock(OutputStream.class);
        outputStreamDelegate.setDelegate(os2);
        outputStreamDelegate.write(1);
        ((OutputStream)Mockito.verify((Object)os1)).write(1);
        ((OutputStream)Mockito.verify((Object)os2)).write(1);
    }

    @Test
    public void writeIntDelegates() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate outputStreamDelegate = new OutputStreamDelegate(os1);
        outputStreamDelegate.write(1);
        ((OutputStream)Mockito.verify((Object)os1)).write(1);
    }

    @Test
    public void writeBytesDelegate() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate outputStreamDelegate = new OutputStreamDelegate(os1);
        byte[] bytes = new byte[]{1};
        outputStreamDelegate.write(bytes);
        ((OutputStream)Mockito.verify((Object)os1)).write(bytes);
    }

    @Test
    public void writeBytesWithOffsetDelegates() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate outputStreamDelegate = new OutputStreamDelegate(os1);
        byte[] bytes = new byte[]{1};
        outputStreamDelegate.write(bytes, 2, bytes.length);
        ((OutputStream)Mockito.verify((Object)os1)).write(bytes, 2, bytes.length);
    }

    @Test
    public void closeDelegates() throws IOException {
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        OutputStreamDelegate outputStreamDelegate = new OutputStreamDelegate(os1);
        outputStreamDelegate.close();
        ((OutputStream)Mockito.verify((Object)os1)).close();
    }
}

