/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.appenders.log4j2.elasticsearch.ReusableIOContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ReusableIOContextTest {
    @Test
    public void canReassignIOContextSourceReference() {
        ByteArrayOutputStream initialSourceRef = new ByteArrayOutputStream();
        ReusableIOContext ctx = this.createDefaultTestIOContext(initialSourceRef);
        ByteArrayOutputStream expectedSourceRef = new ByteArrayOutputStream();
        ctx.setSourceReference((OutputStream)expectedSourceRef);
        Object result = ctx.getSourceReference();
        Assert.assertSame((Object)expectedSourceRef, (Object)result);
    }

    @NotNull
    public ReusableIOContext createDefaultTestIOContext(OutputStream initialSourceRef) {
        return new ReusableIOContext(new BufferRecycler(), initialSourceRef, false);
    }
}

