/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;
import org.appenders.log4j2.elasticsearch.RollingIndexNameFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RollingIndexNameFormatterTest {
    private static final String TEST_INDEX_NAME = "testIndexName";
    private static final String DATE_PATTERN_WITH_MINUTES = "yyyy-MM-dd-HH.mm";
    private static final TimeZone TEST_TIME_ZONE = TimeZone.getTimeZone(RollingIndexNameFormatter.Builder.DEFAULT_TIME_ZONE);
    private static final long DEFAULT_TEST_TIME_IN_MILLIS = RollingIndexNameFormatterTest.getTestTimeInMillis();

    private static long getTestTimeInMillis() {
        return LocalDateTime.of(2017, 12, 20, 23, 54, 0, 0).atZone(ZoneId.of(RollingIndexNameFormatter.Builder.DEFAULT_TIME_ZONE)).toInstant().toEpochMilli();
    }

    public static RollingIndexNameFormatter.Builder createRollingIndexNameFormatterBuilder() {
        RollingIndexNameFormatter.Builder builder = (RollingIndexNameFormatter.Builder)Mockito.spy((Object)RollingIndexNameFormatter.newBuilder());
        Mockito.when((Object)builder.getInitTimeInMillis()).thenReturn((Object)DEFAULT_TEST_TIME_IN_MILLIS);
        builder.withIndexName(TEST_INDEX_NAME);
        builder.withPattern(DATE_PATTERN_WITH_MINUTES);
        builder.withTimeZone(TEST_TIME_ZONE.getID());
        return builder;
    }

    @Test
    public void startsWithoutExceptionsIfSetupIsCorrect() {
        RollingIndexNameFormatter formatter = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder().build();
        Assert.assertNotNull((Object)formatter);
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptioWhenIndexNameIsNull() {
        RollingIndexNameFormatter.Builder builder = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder();
        builder.withIndexName(null);
        builder.build();
    }

    @Test(expected=ConfigurationException.class)
    public void builderThrowsExceptioWhenPatternIsNull() {
        RollingIndexNameFormatter.Builder builder = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder();
        builder.withPattern(null);
        builder.build();
    }

    @Test
    public void returnsCurrentTimeIfEventTimeIsBeforeRolloverTime() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)DEFAULT_TEST_TIME_IN_MILLIS);
        RollingIndexNameFormatter formatter = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder().build();
        String formattedIndexName = formatter.format((Object)logEvent);
        Assert.assertEquals((Object)"testIndexName-2017-12-20-23.54", (Object)formattedIndexName);
    }

    @Test
    public void returnsNextRolloverTimeIfEventTimeIsAfterRolloverTime() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)(DEFAULT_TEST_TIME_IN_MILLIS + TimeUnit.HOURS.toMillis(1L)));
        RollingIndexNameFormatter formatter = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder().build();
        String formattedIndexName = formatter.format((Object)logEvent);
        Assert.assertEquals((Object)"testIndexName-2017-12-21-00.54", (Object)formattedIndexName);
    }

    @Test
    public void returnsPreviousRolloverTimeIfEventTimeIsBeforeCurrentTime() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)(DEFAULT_TEST_TIME_IN_MILLIS - TimeUnit.HOURS.toMillis(1L)));
        RollingIndexNameFormatter formatter = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder().build();
        String formattedIndexName = formatter.format((Object)logEvent);
        Assert.assertEquals((Object)"testIndexName-2017-12-20-22.54", (Object)formattedIndexName);
    }

    @Test
    public void returnsCustomSeparatorFormattedIndexName() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)DEFAULT_TEST_TIME_IN_MILLIS);
        RollingIndexNameFormatter.Builder builder = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder();
        builder.withSeparator(".");
        RollingIndexNameFormatter formatter = builder.build();
        String formattedIndexName = formatter.format((Object)logEvent);
        Assert.assertEquals((Object)"testIndexName.2017-12-20-23.54", (Object)formattedIndexName);
    }

    @Test
    public void returnsDefaultSeparatorFormattedIndexNameWithoutCustomSeparator() {
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)DEFAULT_TEST_TIME_IN_MILLIS);
        RollingIndexNameFormatter formatter = new RollingIndexNameFormatter(TEST_INDEX_NAME, DATE_PATTERN_WITH_MINUTES, DEFAULT_TEST_TIME_IN_MILLIS, TEST_TIME_ZONE);
        String formattedIndexName = formatter.format((Object)logEvent);
        Assert.assertEquals((Object)"testIndexName-2017-12-20-23.54", (Object)formattedIndexName);
    }

    @Test
    public void returnsEventTimeBasedNameInsteadOfCurrentNameDuringRollover() throws InterruptedException {
        final long testNextTimeResult = DEFAULT_TEST_TIME_IN_MILLIS + TimeUnit.MINUTES.toMillis(123L);
        TestFormatter.TEST_PATTERN_PROCESSOR = (PatternProcessor)Mockito.spy((Object)new PatternProcessor("%d{yyyy-MM-dd-HH.mm}"));
        Mockito.when((Object)TestFormatter.TEST_PATTERN_PROCESSOR.getNextTime(((Long)Matchers.any(Long.TYPE)).longValue(), Matchers.eq((int)1), Matchers.eq((boolean)false))).thenAnswer((Answer)new Answer<Long>(){
            private int count = 0;

            public Long answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (++this.count > 1) {
                    return (Long)invocationOnMock.callRealMethod();
                }
                Thread.sleep(100L);
                return testNextTimeResult;
            }
        });
        LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
        Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)(DEFAULT_TEST_TIME_IN_MILLIS + TimeUnit.MINUTES.toMillis(1L)));
        TestFormatter formatter = new TestFormatter(TEST_INDEX_NAME, DATE_PATTERN_WITH_MINUTES, DEFAULT_TEST_TIME_IN_MILLIS, TEST_TIME_ZONE);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread((IndexNameFormatter)formatter, logEvent, countDownLatch){
            final /* synthetic */ IndexNameFormatter val$formatter;
            final /* synthetic */ LogEvent val$logEvent;
            final /* synthetic */ CountDownLatch val$countDownLatch;
            {
                this.val$formatter = indexNameFormatter;
                this.val$logEvent = logEvent;
                this.val$countDownLatch = countDownLatch;
            }

            @Override
            public void run() {
                this.val$formatter.format((Object)this.val$logEvent);
                this.val$countDownLatch.countDown();
            }
        }.start();
        Thread.sleep(50L);
        String formattedIndexName = formatter.format(logEvent);
        Assert.assertEquals((Object)"testIndexName-2017-12-20-23.55", (Object)formattedIndexName);
        countDownLatch.await();
        Assert.assertEquals((long)testNextTimeResult, (long)((RollingIndexNameFormatter)formatter).getNextRolloverTime());
    }

    @Test
    public void concurrencyTest() throws InterruptedException {
        for (int ii = 0; ii < 100; ++ii) {
            RollingIndexNameFormatter formatter = RollingIndexNameFormatterTest.createRollingIndexNameFormatterBuilder().build();
            this.runSingleConcurrencyTest((IndexNameFormatter)formatter, 20);
        }
    }

    private void runSingleConcurrencyTest(IndexNameFormatter formatter, int numberOfThreads) throws InterruptedException {
        ConcurrentLinkedQueue<TestTuple> logEvents = this.generateLogEvents();
        CountDownLatch countDownLatch = new CountDownLatch(numberOfThreads);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int ii = 0; ii < numberOfThreads; ++ii) {
            threads.add(new Thread(() -> {
                try {
                    while (!logEvents.isEmpty()) {
                        TestTuple tuple = (TestTuple)logEvents.poll();
                        if (tuple == null) continue;
                        String formattedIndexName = formatter.format((Object)tuple.getLogEvent());
                        if (tuple.getIncrement() < 0) {
                            Assert.assertEquals((Object)"testIndexName-2017-12-20-23.53", (Object)formattedIndexName);
                        }
                        if (tuple.getIncrement() == 0) {
                            Assert.assertEquals((Object)"testIndexName-2017-12-20-23.54", (Object)formattedIndexName);
                        }
                        if (tuple.getIncrement() <= 0) continue;
                        Assert.assertEquals((Object)"testIndexName-2017-12-20-23.55", (Object)formattedIndexName);
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
            }));
        }
        threads.stream().forEach(th -> th.start());
        countDownLatch.await();
    }

    private ConcurrentLinkedQueue<TestTuple> generateLogEvents() {
        ConcurrentLinkedQueue<TestTuple> events = new ConcurrentLinkedQueue<TestTuple>();
        Random random = new Random();
        for (int ii = 0; ii < 1000; ++ii) {
            LogEvent logEvent = (LogEvent)Mockito.mock(LogEvent.class);
            int increment = random.nextInt(3) - 1;
            Mockito.when((Object)logEvent.getTimeMillis()).thenReturn((Object)(DEFAULT_TEST_TIME_IN_MILLIS + (long)(increment * 60000) + (long)random.nextInt(60000)));
            events.add(new TestTuple(logEvent, increment));
        }
        return events;
    }

    public static class TestTuple {
        private LogEvent logEvent;
        private int increment;

        public TestTuple(LogEvent logEvent, int increment) {
            this.logEvent = logEvent;
            this.increment = increment;
        }

        public LogEvent getLogEvent() {
            return this.logEvent;
        }

        public int getIncrement() {
            return this.increment;
        }
    }

    public static class TestFormatter
    extends RollingIndexNameFormatter {
        public static PatternProcessor TEST_PATTERN_PROCESSOR;

        public TestFormatter(String indexName, String pattern, long initTimeInMillis, TimeZone timeZone) {
            super(indexName, pattern, initTimeInMillis, timeZone);
        }

        protected PatternProcessor createPatternProcessor(String pattern) {
            return TEST_PATTERN_PROCESSOR;
        }
    }
}

