/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonpCharacterEscapes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.appenders.log4j2.elasticsearch.SingleThreadJsonFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class SingleThreadJsonFactoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void createFileBasedGeneratorNotSupported() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("File not supported. Use OutputStream");
        factory.createGenerator((File)Mockito.mock(File.class), JsonEncoding.UTF8);
    }

    @Test
    public void createGeneratorWithNonUtf8EncodingNotSupported() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        this.expectedException.expect(UnsupportedEncodingException.class);
        this.expectedException.expectMessage("Encoding not supported: " + JsonEncoding.UTF16_BE.getJavaName());
        factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF16_BE);
    }

    @Test
    public void createWriterBasedGeneratorNotSupported() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Writer not supported. Use OutputStream");
        factory.createGenerator((Writer)Mockito.mock(Writer.class));
    }

    @Test
    public void canCreateOutputStreamBasedGenerator() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        JsonGenerator generator1 = factory.createGenerator(os1, JsonEncoding.UTF8);
        Assert.assertNotNull((Object)generator1);
    }

    @Test
    public void createOutputStreamBasedGeneratorReplacesDelegateTarget() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        factory.createGenerator(os1, JsonEncoding.UTF8);
        Assert.assertSame((Object)factory.outputStreamDelegate.getDelegate(), (Object)os1);
        OutputStream os2 = (OutputStream)Mockito.mock(OutputStream.class);
        factory.createGenerator(os2, JsonEncoding.UTF8);
        Assert.assertSame((Object)factory.outputStreamDelegate.getDelegate(), (Object)os2);
    }

    @Test
    public void createGeneratorCallsReturnSameInstanceEveryTime() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        JsonGenerator generator1 = factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF8);
        JsonGenerator generator2 = factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF8);
        Assert.assertNotNull((Object)generator1);
        Assert.assertSame((Object)generator1, (Object)generator2);
    }

    @Test
    public void createDataOutputWrapperCallsReplacesDelegateTarget() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        factory._createDataOutputWrapper(dataOutput1);
        Assert.assertSame((Object)factory.dataOutputDelegate.getDelegate(), (Object)dataOutput1);
        DataOutput dataOutput2 = (DataOutput)Mockito.mock(DataOutput.class);
        factory._createDataOutputWrapper(dataOutput2);
        Assert.assertSame((Object)factory.dataOutputDelegate.getDelegate(), (Object)dataOutput2);
    }

    @Test
    public void createDataOutputWrapperCallsReturnSameInstanceEveryTime() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        DataOutput dataOutput1 = (DataOutput)Mockito.mock(DataOutput.class);
        OutputStream outputStream1 = factory._createDataOutputWrapper(dataOutput1);
        DataOutput dataOutput2 = (DataOutput)Mockito.mock(DataOutput.class);
        OutputStream outputStream2 = factory._createDataOutputWrapper(dataOutput2);
        Assert.assertSame((Object)outputStream1, (Object)outputStream2);
    }

    @Test
    public void _createUTF8GeneratorResetsDelegatesAndGenerator() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        OutputStream os1 = (OutputStream)Mockito.mock(OutputStream.class);
        factory._createUTF8Generator(os1, (IOContext)Mockito.mock(IOContext.class));
        Assert.assertSame((Object)factory.outputStreamDelegate.getDelegate(), (Object)os1);
        Assert.assertSame((Object)factory.ioContext.getSourceReference(), (Object)os1);
    }

    @Test
    public void canSetCharacterEscapesIfNotNull() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        factory.setCharacterEscapes((CharacterEscapes)JsonpCharacterEscapes.instance());
        JsonGenerator generator = factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF8);
        Assert.assertSame((Object)JsonpCharacterEscapes.instance(), (Object)factory.getCharacterEscapes());
        Assert.assertSame((Object)JsonpCharacterEscapes.instance(), (Object)generator.getCharacterEscapes());
    }

    @Test
    public void doesNotSetCharacterEscapesIfNull() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        factory.setCharacterEscapes((CharacterEscapes)JsonpCharacterEscapes.instance());
        JsonGenerator generator1 = factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF8);
        factory.setCharacterEscapes(null);
        JsonGenerator generator2 = factory.createGenerator((OutputStream)Mockito.mock(OutputStream.class), JsonEncoding.UTF8);
        Assert.assertSame((Object)JsonpCharacterEscapes.instance(), (Object)factory.getCharacterEscapes());
        Assert.assertSame((Object)JsonpCharacterEscapes.instance(), (Object)generator1.getCharacterEscapes());
        Assert.assertSame((Object)JsonpCharacterEscapes.instance(), (Object)generator2.getCharacterEscapes());
    }

    @Test
    public void canSetRootValueSeparator() throws IOException {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        factory.setRootValueSeparator("#");
        JsonGenerator generator = factory.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
        generator.writeStartObject();
        generator.writeStringField("field1", "value1");
        generator.writeEndObject();
        generator.close();
        generator.writeStartObject();
        generator.writeStringField("field2", "value2");
        generator.writeEndObject();
        generator.close();
        Assert.assertTrue((boolean)outputStream.toString("UTF-8").contains("#"));
    }

    @Test
    public void doesNotSetSeparatorBackToDefaultRootValueSeparator() {
        SingleThreadJsonFactory factory = new SingleThreadJsonFactory();
        factory.setRootValueSeparator("#");
        Assert.assertEquals((Object)"#", (Object)factory.getRootValueSeparator());
        factory.setRootValueSeparator(JsonFactory.DEFAULT_ROOT_VALUE_SEPARATOR.getValue());
        Assert.assertEquals((Object)"#", (Object)factory.getRootValueSeparator());
    }

    @Test
    public void copyDoesNotUseSourceSharedComponents() {
        SingleThreadJsonFactory factory1 = new SingleThreadJsonFactory();
        factory1.dataOutputDelegate.setDelegate((DataOutput)Mockito.mock(DataOutput.class));
        SingleThreadJsonFactory factory2 = factory1.copy();
        Assert.assertNotSame((Object)factory1.outputStreamDelegate, (Object)factory2.outputStreamDelegate);
        Assert.assertNotSame((Object)factory1.outputStreamDelegate.getDelegate(), (Object)factory2.outputStreamDelegate.getDelegate());
        Assert.assertNotSame((Object)factory1.dataOutputDelegate, (Object)factory2.dataOutputDelegate);
        Assert.assertNotSame((Object)factory1.dataOutputDelegate.getDelegate(), (Object)factory2.dataOutputDelegate.getDelegate());
        Assert.assertNotSame((Object)factory1.ioContext, (Object)factory2.ioContext);
        Assert.assertNotSame((Object)factory1.ioContext.getSourceReference(), (Object)factory2.ioContext.getSourceReference());
        Assert.assertNotSame((Object)factory1.jsonGenerator, (Object)factory2.jsonGenerator);
        Assert.assertNotSame((Object)factory1.writeCtxAccessor, (Object)factory2.writeCtxAccessor);
    }
}

