/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.BulkEmitter;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.TestHttpObjectFactory;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;
import org.mockito.Mockito;

public class TestBatchEmitterFactory
extends BatchEmitterServiceProvider
implements BatchEmitterFactory<BatchEmitter> {
    private BatchEmitter spiedEmitter;

    public boolean accepts(Class clientObjectFactoryClass) {
        return TestHttpObjectFactory.class.isAssignableFrom(clientObjectFactoryClass);
    }

    public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
        if (this.spiedEmitter == null) {
            BulkEmitter emitter = new BulkEmitter(batchSize, deliveryInterval, clientObjectFactory.createBatchOperations());
            emitter.addListener(clientObjectFactory.createBatchListener(failoverPolicy));
            this.spiedEmitter = (BatchEmitter)Mockito.spy((Object)emitter);
        }
        return this.spiedEmitter;
    }
}

