/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.UUID;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ValueResolverTest {
    @Test
    public void noopResolverDoesNotChangeGivenValue() {
        String expected = UUID.randomUUID().toString();
        String resolved = ValueResolver.NO_OP.resolve(expected);
        Assert.assertSame((Object)expected, (Object)resolved);
    }

    @Test
    public void noopResolverReturnsCurrentVirtualPropertyValue() {
        VirtualProperty property = (VirtualProperty)Mockito.mock(VirtualProperty.class);
        String expected = UUID.randomUUID().toString();
        Mockito.when((Object)property.getValue()).thenReturn((Object)expected);
        String resolved = ValueResolver.NO_OP.resolve(property);
        Assert.assertSame((Object)expected, (Object)resolved);
    }
}

