/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import java.util.UUID;
import org.apache.logging.log4j.core.LogEvent;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualPropertiesWriter;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.appenders.log4j2.elasticsearch.VirtualPropertyFilter;
import org.appenders.log4j2.elasticsearch.VirtualPropertyTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class VirtualPropertiesWriterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void defaultConstructorIsNotSupported() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Invalid use of " + VirtualPropertiesWriter.class.getSimpleName());
        new VirtualPropertiesWriter();
    }

    @Test
    public void startsSuccessfully() {
        VirtualPropertiesWriter result = new VirtualPropertiesWriter(new VirtualProperty[0], (ValueResolver)Mockito.mock(ValueResolver.class));
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void overridenValueIsNotSupported() {
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[0], (ValueResolver)Mockito.mock(ValueResolver.class));
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Should not be used with this implementation");
        writer.value(null, null, null);
    }

    @Test
    public void overridenFixAccessIsNoop() {
        ObjectMapper objectMapper = new ObjectMapper();
        SerializationConfig config = objectMapper.getSerializationConfig();
        VirtualPropertiesWriter writer = (VirtualPropertiesWriter)Mockito.spy((Object)new VirtualPropertiesWriter(new VirtualProperty[0], (ValueResolver)Mockito.mock(ValueResolver.class)));
        writer.fixAccess(config);
        ((VirtualPropertiesWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.never())).getMember();
    }

    @Test
    public void withConfigReturnsConfiguredWriter() {
        ObjectMapper objectMapper = new ObjectMapper();
        SerializationConfig config = objectMapper.getSerializationConfig();
        VirtualPropertiesWriter writer = (VirtualPropertiesWriter)Mockito.spy((Object)new VirtualPropertiesWriter(new VirtualProperty[0], (ValueResolver)Mockito.mock(ValueResolver.class), new VirtualPropertyFilter[0]));
        JavaType javaType = config.constructType(LogEvent.class);
        AnnotatedClass annotatedClass = this.createTestAnnotatedClass(config, javaType);
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = this.getTestBeanPropertyDefinition(config, javaType, annotatedClass);
        VirtualPropertiesWriter result = writer.withConfig((MapperConfig)config, annotatedClass, (BeanPropertyDefinition)simpleBeanPropertyDefinition, config.constructType(VirtualProperty.class));
        Assert.assertArrayEquals((Object[])writer.virtualProperties, (Object[])result.virtualProperties);
        Assert.assertEquals((Object)writer.valueResolver, (Object)result.valueResolver);
        Assert.assertEquals((Object[])writer.filters, (Object[])result.filters);
    }

    @Test
    public void writerCreatedWithDeprecatedConstructorWritesGivenProperties() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        SerializationConfig config = objectMapper.getSerializationConfig();
        JavaType javaType = config.constructType(LogEvent.class);
        AnnotatedClass annotatedClass = this.createTestAnnotatedClass(config, javaType);
        SimpleBeanPropertyDefinition simpleBeanPropertyDefinition = this.getTestBeanPropertyDefinition(config, javaType, annotatedClass);
        String expectedName = UUID.randomUUID().toString();
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = (VirtualProperty)Mockito.spy((Object)this.createNonDynamicVirtualProperty(expectedName, expectedValue));
        ValueResolver valueResolver = this.createTestValueResolver(virtualProperty, expectedValue);
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter((BeanPropertyDefinition)simpleBeanPropertyDefinition, (Annotations)new AnnotationCollector.OneAnnotation(annotatedClass.getRawType(), annotatedClass.getAnnotations().get(JsonAppend.class)), javaType, new VirtualProperty[]{virtualProperty}, valueResolver);
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        writer.serializeAsField(new Object(), jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeFieldName((String)ArgumentMatchers.eq((Object)expectedName));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeString((String)ArgumentMatchers.eq((Object)expectedValue));
    }

    @Test
    public void serializeAsFieldResolvesVirtualPropertyValue() throws Exception {
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = (VirtualProperty)Mockito.spy((Object)this.createNonDynamicVirtualProperty(null, expectedValue));
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[]{virtualProperty}, valueResolver);
        writer.serializeAsField(new Object(), (JsonGenerator)Mockito.mock(JsonGenerator.class), (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((ValueResolver)Mockito.verify((Object)valueResolver)).resolve((VirtualProperty)ArgumentMatchers.eq((Object)virtualProperty));
    }

    @Test
    public void serializeAsFieldWritesGivenProperties() throws Exception {
        String expectedName = UUID.randomUUID().toString();
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty excludedVirtualProperty = this.createNonDynamicVirtualProperty(expectedName, expectedValue);
        VirtualProperty virtualProperty = this.createNonDynamicVirtualProperty(expectedName, expectedValue);
        ValueResolver valueResolver = this.createTestValueResolver(virtualProperty, expectedValue);
        VirtualPropertyFilter virtualPropertyFilter = this.createNonExcludingTestVirtualPropertyFilter(expectedName, expectedValue);
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[]{excludedVirtualProperty, virtualProperty}, valueResolver, new VirtualPropertyFilter[]{virtualPropertyFilter});
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        writer.serializeAsField(new Object(), jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeFieldName((String)ArgumentMatchers.eq((Object)expectedName));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeString((String)ArgumentMatchers.eq((Object)expectedValue));
    }

    @Test
    public void serializeAsFieldDoesNotWritePropertiesIfNoPropertiesProvided() throws Exception {
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[0], (ValueResolver)Mockito.mock(ValueResolver.class));
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        writer.serializeAsField(new Object(), jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeFieldName(ArgumentMatchers.anyString());
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeString(ArgumentMatchers.anyString());
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeString((String)ArgumentMatchers.eq((Object)null));
    }

    @Test
    public void serializeAsFieldDoesNotWritePropertiesIfPropertiesExcludedByFilters() throws Exception {
        VirtualProperty virtualProperty = (VirtualProperty)Mockito.mock(VirtualProperty.class);
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        VirtualPropertyFilter virtualPropertyFilter = (VirtualPropertyFilter)Mockito.mock(VirtualPropertyFilter.class);
        Mockito.when((Object)virtualPropertyFilter.isIncluded((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)false);
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[]{virtualProperty}, valueResolver, new VirtualPropertyFilter[]{virtualPropertyFilter});
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        writer.serializeAsField(new Object(), jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeFieldName(ArgumentMatchers.anyString());
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeString(ArgumentMatchers.anyString());
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator, (VerificationMode)Mockito.never())).writeString((String)ArgumentMatchers.eq((Object)null));
    }

    @Test
    public void serializeAsFieldWritesPropertiesIfPropertiesNotExcludedByFilters() throws Exception {
        String expectedName = UUID.randomUUID().toString();
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty virtualProperty = (VirtualProperty)Mockito.spy((Object)this.createNonDynamicVirtualProperty(expectedName, expectedValue));
        ValueResolver valueResolver = this.createTestValueResolver(virtualProperty, expectedValue);
        VirtualPropertyFilter virtualPropertyFilter = this.createNonExcludingTestVirtualPropertyFilter(expectedName, expectedValue);
        VirtualPropertiesWriter writer = new VirtualPropertiesWriter(new VirtualProperty[]{virtualProperty}, valueResolver, new VirtualPropertyFilter[]{virtualPropertyFilter});
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        writer.serializeAsField(new Object(), jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeFieldName((String)ArgumentMatchers.eq((Object)expectedName));
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeString((String)ArgumentMatchers.eq((Object)expectedValue));
    }

    private ValueResolver createTestValueResolver(VirtualProperty virtualProperty, String expectedValue) {
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        Mockito.when((Object)valueResolver.resolve(virtualProperty)).thenReturn((Object)expectedValue);
        return valueResolver;
    }

    private VirtualProperty createNonDynamicVirtualProperty(String expectedName, String expectedValue) {
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder();
        if (expectedName != null) {
            builder.withName(expectedName);
        }
        if (expectedValue != null) {
            builder.withValue(expectedValue);
        }
        return builder.withDynamic(false).build();
    }

    private VirtualPropertyFilter createNonExcludingTestVirtualPropertyFilter(String expectedName, String expectedValue) {
        VirtualPropertyFilter virtualPropertyFilter = (VirtualPropertyFilter)Mockito.mock(VirtualPropertyFilter.class);
        Mockito.when((Object)virtualPropertyFilter.isIncluded(expectedName, expectedValue)).thenReturn((Object)true);
        return virtualPropertyFilter;
    }

    private SimpleBeanPropertyDefinition getTestBeanPropertyDefinition(SerializationConfig config, JavaType javaType, AnnotatedClass annotatedClass) {
        return SimpleBeanPropertyDefinition.construct((MapperConfig)config, (AnnotatedMember)new VirtualAnnotatedMember((TypeResolutionContext)annotatedClass, LogEvent.class, "virtualProperties", javaType));
    }

    private AnnotatedClass createTestAnnotatedClass(SerializationConfig config, JavaType javaType) {
        return AnnotatedClassResolver.resolve((MapperConfig)config, (JavaType)javaType, null);
    }
}

