/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.UUID;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class VirtualPropertyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builderFailsWhenNameIsNull() {
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withName(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No name provided for VirtualProperty");
        builder.build();
    }

    @Test
    public void builderFailsWhenValueIsNull() {
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withValue(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("No value provided for VirtualProperty");
        builder.build();
    }

    @Test
    public void builderSetsName() {
        String expectedName = UUID.randomUUID().toString();
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withName(expectedName);
        VirtualProperty property = builder.build();
        Assert.assertEquals((Object)expectedName, (Object)property.getName());
    }

    @Test
    public void builderSetsValue() {
        String expectedName = UUID.randomUUID().toString();
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withName(expectedName);
        VirtualProperty property = builder.build();
        Assert.assertEquals((Object)expectedName, (Object)property.getName());
    }

    @Test
    public void builderSetsDynamic() {
        VirtualProperty.Builder builder = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withDynamic(true);
        VirtualProperty property = builder.build();
        Assert.assertTrue((boolean)property.isDynamic());
    }

    @Test
    public void valueCanBeOverridenAfterCreation() {
        VirtualProperty property = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().build();
        String expectedValue = UUID.randomUUID().toString();
        Assert.assertNotEquals((Object)expectedValue, (Object)property.getValue());
        property.setValue(expectedValue);
        Assert.assertEquals((Object)expectedValue, (Object)property.getValue());
    }

    @Test
    public void toStringPrintsFormattedInfo() {
        String expectedName = UUID.randomUUID().toString();
        String expectedValue = UUID.randomUUID().toString();
        VirtualProperty property = VirtualPropertyTest.createDefaultVirtualPropertyBuilder().withName(expectedName).withValue(expectedValue).build();
        String result = property.toString();
        Assert.assertEquals((Object)result, (Object)String.format("%s=%s", expectedName, expectedValue));
    }

    public static VirtualProperty.Builder createDefaultVirtualPropertyBuilder() {
        return VirtualProperty.newBuilder().withName(UUID.randomUUID().toString()).withValue(UUID.randomUUID().toString()).withDynamic(false);
    }
}

