/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.backoff;

import org.appenders.log4j2.elasticsearch.backoff.BatchLimitBackoffPolicy;
import org.junit.Assert;
import org.junit.Test;

public class BatchLimitBackoffPolicyTest {
    public static final int DEFAULT_TEST_MAX_BATCHES_IN_FLIGHT = 1;

    @Test
    public void buildsSuccessfully() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        Assert.assertNotNull((Object)policy);
    }

    @Test
    public void registerIncrementsCurrentCount() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        Assert.assertFalse((boolean)policy.shouldApply(null));
        policy.register(null);
        Assert.assertTrue((boolean)policy.shouldApply(null));
    }

    @Test
    public void deregisterDecrementsCurrentCount() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        Assert.assertFalse((boolean)policy.shouldApply(null));
        policy.register(null);
        Assert.assertTrue((boolean)policy.shouldApply(null));
        policy.deregister(null);
        Assert.assertFalse((boolean)policy.shouldApply(null));
    }

    @Test
    public void shouldApplyReturnsFalseIfBatchesInFlightLowerThanConfigured() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        boolean result = policy.shouldApply(null);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldApplyReturnsTrueIfBatchesInFlightEqualToConfigured() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        Assert.assertFalse((boolean)policy.shouldApply(null));
        policy.register(null);
        Assert.assertTrue((boolean)policy.shouldApply(null));
    }

    @Test
    public void shouldApplyReturnsTrueIfBatchesInFlightHigherThanConfigured() {
        BatchLimitBackoffPolicy policy = new BatchLimitBackoffPolicy(1);
        Assert.assertFalse((boolean)policy.shouldApply(null));
        policy.register(null);
        policy.register(null);
        Assert.assertTrue((boolean)policy.shouldApply(null));
    }
}

