/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import com.fasterxml.jackson.core.JsonParser;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.util.UUID;
import org.appenders.log4j2.elasticsearch.failover.ByteBufDeserializer;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ByteBufDeserializerTest {
    @Test
    public void writesBytesIntoPooledBuffer() throws IOException {
        ByteBufDeserializer deserializer = (ByteBufDeserializer)Mockito.spy((Object)new ByteBufDeserializer());
        ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Mockito.when((Object)deserializer.allocator()).thenReturn((Object)allocator);
        CompositeByteBuf byteBuf = (CompositeByteBuf)Mockito.mock(CompositeByteBuf.class);
        Mockito.when((Object)allocator.compositeBuffer(ArgumentMatchers.eq((int)2))).thenReturn((Object)byteBuf);
        JsonParser jsonParser = (JsonParser)Mockito.mock(JsonParser.class);
        byte[] bytes = UUID.randomUUID().toString().getBytes();
        Mockito.when((Object)jsonParser.getBinaryValue()).thenReturn((Object)bytes);
        deserializer.deserialize(jsonParser, null);
        ((CompositeByteBuf)Mockito.verify((Object)byteBuf)).writeBytes((byte[])ArgumentMatchers.eq((Object)bytes));
    }
}

