/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import org.appenders.log4j2.elasticsearch.failover.ByteBufSerializer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ByteBufSerializerTest {
    @Test
    public void handledTypeIsByteBuf() {
        ByteBufSerializer serializer = new ByteBufSerializer();
        Class handledType = serializer.handledType();
        Assert.assertEquals(ByteBuf.class, (Object)handledType);
    }

    @Test
    public void serializesGivenByteBuf() throws IOException {
        ByteBufSerializer serializer = new ByteBufSerializer();
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        ByteBuf byteBuf = (ByteBuf)Mockito.mock(ByteBuf.class);
        Mockito.when((Object)byteBuf.writerIndex()).thenReturn((Object)10);
        serializer.serialize(byteBuf, jsonGenerator, (SerializerProvider)Mockito.mock(SerializerProvider.class));
        ((ByteBuf)Mockito.verify((Object)byteBuf)).resetReaderIndex();
        ((JsonGenerator)Mockito.verify((Object)jsonGenerator)).writeBinary((InputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((int)10));
    }

    @Test
    public void serializeWithTypeDelegatesToSerialize() throws IOException {
        ByteBufSerializer serializer = (ByteBufSerializer)Mockito.spy((Object)new ByteBufSerializer());
        ByteBuf byteBuf = (ByteBuf)Mockito.mock(ByteBuf.class);
        JsonGenerator jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
        SerializerProvider serializerProvider = (SerializerProvider)Mockito.mock(SerializerProvider.class);
        serializer.serializeWithType(byteBuf, jsonGenerator, serializerProvider, (TypeSerializer)Mockito.mock(TypeSerializer.class));
        ((ByteBufSerializer)Mockito.verify((Object)serializer)).serialize((ByteBuf)ArgumentMatchers.eq((Object)byteBuf), (JsonGenerator)ArgumentMatchers.eq((Object)jsonGenerator), (SerializerProvider)ArgumentMatchers.eq((Object)serializerProvider));
    }
}

