/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.map.ChronicleMap;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.DelayedShutdown;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.failover.ChronicleMapRetryFailoverPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailoverListener;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeys;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.RetryListener;
import org.appenders.log4j2.elasticsearch.failover.RetryProcessorTest;
import org.appenders.log4j2.elasticsearch.failover.SingleKeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.UUIDSequenceTest;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ChronicleMapRetryFailoverPolicyTest {
    public static final long DEFAULT_TEST_SEQUENCE_ID = 1L;
    private static final Random random = new Random();
    public static final int TEST_NUMBER_OF_ENTRIES = 100;
    public static final long DEFAULT_TEST_MONITOR_TASK_INTERVAL = random.nextInt(100) + 100;
    public static final int DEFAULT_TEST_RETRY_INTERVAL = random.nextInt(100) + 200;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        System.setProperty("appenders.failover.keysequence.consistencyCheckDelay", "10");
    }

    @Test
    public void builderBuildsSuccessfully() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder();
        ChronicleMapRetryFailoverPolicy policy = builder.build();
        Assert.assertNotNull((Object)policy);
    }

    @Test
    public void builderThrowsIfFileNameIsNull() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withFileName(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("fileName was not provided");
        builder.build();
    }

    @Test
    public void builderThrowsIfAverageValueSizeIsTooLow() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withAverageValueSize(511);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("averageValueSize must be higher than or equal 1024");
        builder.build();
    }

    @Test
    public void builderThrowsIfNumberOfEntriesIsTooLow() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withNumberOfEntries(2L);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("numberOfEntries must be higher than 2");
        builder.build();
    }

    @Test
    public void builderThrowsIfBatchSizeIsTooLow() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withBatchSize(0);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("batchSize must be higher than 0");
        builder.build();
    }

    @Test
    public void builderThrowsOnMapInitializationIOException() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = (ChronicleMapRetryFailoverPolicy.Builder)Mockito.spy((Object)this.createDefaultTestFailoverPolicyBuilder());
        IOException testException = (IOException)Mockito.spy((Object)new IOException("test exception"));
        ((ChronicleMapRetryFailoverPolicy.Builder)Mockito.doThrow((Throwable[])new Throwable[]{testException}).when((Object)builder)).createChronicleMap();
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Could not initialize");
        this.expectedException.expectCause((Matcher)new ExceptionCauseMatcher(testException));
        builder.build();
    }

    @Test
    public void builderThrowsIfKeySequenceSelectorIsNull() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withKeySequenceSelector(null);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(KeySequenceSelector.class.getSimpleName() + " was not provided for " + ChronicleMapRetryFailoverPolicy.class.getSimpleName());
        builder.build();
    }

    @Test
    public void builderThrowsIfKeySequenceSelectorReturnsNull() throws IOException {
        KeySequenceSelector keySequenceSelector = (KeySequenceSelector)Mockito.mock(KeySequenceSelector.class);
        Mockito.when((Object)keySequenceSelector.firstAvailable()).thenReturn(null);
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withKeySequenceSelector(keySequenceSelector);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("Could not initialize " + ChronicleMapRetryFailoverPolicy.class.getSimpleName());
        this.expectedException.expectCause((Matcher)new ExceptionMatcher(IllegalStateException.class, "Failed to find a valid key sequence for ChronicleMapRetryFailoverPolicy"));
        builder.build();
    }

    @Test
    public void builderConfiguresRetryDelay() throws IOException {
        long expectedInterval = DEFAULT_TEST_RETRY_INTERVAL;
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withRetryDelay(expectedInterval);
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)builder.build());
        failoverPolicy.addListener((FailoverListener)Mockito.mock(RetryListener.class));
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Mockito.when((Object)failoverPolicy.createExecutor((String)ArgumentMatchers.any())).thenReturn((Object)executorService);
        failoverPolicy.start();
        ((ScheduledExecutorService)Mockito.verify((Object)executorService)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)expectedInterval), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
    }

    @Test
    public void failoverListenerIsAddedIfInstanceOfRetryListener() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withRetryDelay((long)DEFAULT_TEST_RETRY_INTERVAL);
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)builder.build());
        failoverPolicy.addListener((FailoverListener)Mockito.mock(RetryListener.class));
        Assert.assertEquals((long)1L, (long)failoverPolicy.retryListeners.length);
    }

    @Test
    public void failoverListenerIsNotAddedIfNotInstanceOfRetryListener() throws IOException {
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder().withRetryDelay((long)DEFAULT_TEST_RETRY_INTERVAL);
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)builder.build());
        failoverPolicy.addListener((FailoverListener)Mockito.mock(FailoverListener.class));
        Assert.assertEquals((long)0L, (long)failoverPolicy.retryListeners.length);
    }

    @Test
    public void defaultHashCorruptionListenerExtractsExceptionIfAvailable() throws IOException {
        ChronicleHashCorruption corruption = (ChronicleHashCorruption)Mockito.mock(ChronicleHashCorruption.class);
        Mockito.when((Object)corruption.exception()).thenReturn(Mockito.mock(IOException.class));
        ChronicleMapRetryFailoverPolicy.HashCorruptionListener listener = this.createDefaultTestFailoverPolicyBuilder().createCorruptionListener();
        listener.onCorruption(corruption);
        ((ChronicleHashCorruption)Mockito.verify((Object)corruption, (VerificationMode)Mockito.times((int)2))).exception();
        ((ChronicleHashCorruption)Mockito.verify((Object)corruption, (VerificationMode)Mockito.times((int)1))).message();
    }

    @Test
    public void defaultHashCorruptionListenerDoesNotExtractExceptionIfNotAvailable() throws IOException {
        ChronicleHashCorruption corruption = (ChronicleHashCorruption)Mockito.mock(ChronicleHashCorruption.class);
        ChronicleMapRetryFailoverPolicy.HashCorruptionListener listener = this.createDefaultTestFailoverPolicyBuilder().createCorruptionListener();
        listener.onCorruption(corruption);
        ((ChronicleHashCorruption)Mockito.verify((Object)corruption, (VerificationMode)Mockito.times((int)1))).exception();
        ((ChronicleHashCorruption)Mockito.verify((Object)corruption, (VerificationMode)Mockito.times((int)1))).message();
    }

    @Test
    public void deliverClaimsNextWriterKey() throws IOException {
        KeySequence keySequence = (KeySequence)Mockito.mock(KeySequence.class);
        KeySequenceSelector keySequenceSelector = (KeySequenceSelector)Mockito.mock(KeySequenceSelector.class);
        Mockito.when((Object)keySequenceSelector.firstAvailable()).thenReturn((Object)keySequence);
        Mockito.when((Object)keySequenceSelector.currentKeySequence()).thenReturn(() -> keySequence);
        String fileName = this.createTempFile().getAbsolutePath();
        ChronicleMapRetryFailoverPolicy.Builder builder = ChronicleMapRetryFailoverPolicy.newBuilder().withKeySequenceSelector(keySequenceSelector).withFileName(fileName).withNumberOfEntries(100L);
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        ItemSource failedItemSource = (ItemSource)Mockito.mock(ItemSource.class);
        failoverPolicy.deliver(failedItemSource);
        ((KeySequence)Mockito.verify((Object)keySequence)).nextWriterKey();
    }

    @Test
    public void failedItemIsStoredIfBothKeyAndFailedItemAreNotNull() throws IOException {
        String fileName = this.createTempFile().getAbsolutePath();
        ChronicleMap<CharSequence, ItemSource> failedItems = this.createDefaultTestChronicleMap();
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder(fileName, failedItems);
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        ItemSource failedItemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        String expectedKey = UUID.randomUUID().toString();
        boolean result = failoverPolicy.tryPut((CharSequence)expectedKey, failedItemSource);
        Assert.assertTrue((boolean)result);
        ((ChronicleMap)Mockito.verify(failedItems)).put(ArgumentMatchers.eq((Object)expectedKey), ArgumentMatchers.eq((Object)failedItemSource));
    }

    @Test
    public void failedItemIsNotStoredIfFailedItemIsNull() throws IOException {
        String fileName = this.createTempFile().getAbsolutePath();
        ChronicleMap<CharSequence, ItemSource> failedItems = this.createDefaultTestChronicleMap();
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder(fileName, failedItems);
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        String unexpectedKey = UUID.randomUUID().toString();
        boolean result = failoverPolicy.tryPut((CharSequence)unexpectedKey, null);
        Assert.assertFalse((boolean)result);
        ((ChronicleMap)Mockito.verify(failedItems, (VerificationMode)Mockito.times((int)0))).put(ArgumentMatchers.eq((Object)unexpectedKey), ArgumentMatchers.any());
    }

    @Test
    public void exceptionCountIsIncrementedOnStorageFailure() throws IOException {
        ChronicleMapRetryFailoverPolicy failoverPolicy = this.createDefaultTestFailoverPolicyBuilder().build();
        ItemSource failedItemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        boolean result = failoverPolicy.tryPut(null, failedItemSource);
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((long)1L, (long)failoverPolicy.storeFailureCount.get());
    }

    @Test
    public void metricPrinterUsesMapSize() throws IOException {
        ChronicleMap<CharSequence, ItemSource> failedItems = this.createDefaultTestChronicleMap();
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(1L).withRepository(new KeySequenceConfigRepository(failedItems));
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        RetryProcessorTest.fillMap(failedItems, 1, (KeySequenceSelector)keySequenceSelector, () -> itemSource);
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder(this.createTempFile().getAbsolutePath(), failedItems).withKeySequenceSelector((KeySequenceSelector)keySequenceSelector);
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        ChronicleMapRetryFailoverPolicy.MetricsPrinter metricsPrinter = new ChronicleMapRetryFailoverPolicy.MetricsPrinter(failoverPolicy);
        ((ChronicleMap)Mockito.verify(failedItems, (VerificationMode)Mockito.never())).size();
        metricsPrinter.run();
        ((ChronicleMap)Mockito.verify(failedItems)).size();
    }

    @Test
    public void lifecycleStartFailsIfNoListenersConfigured() throws IOException {
        ChronicleMapRetryFailoverPolicy failoverPolicy = this.createDefaultTestFailoverPolicyBuilder().build();
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(RetryListener.class.getSimpleName() + " was not provided for " + ChronicleMapRetryFailoverPolicy.class.getSimpleName());
        failoverPolicy.start();
    }

    @Test
    public void lifecycleStartSchedulesMetricsPrinterIfConfigured() throws IOException {
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)new ChronicleMapRetryFailoverPolicy(this.createDefaultTestFailoverPolicyBuilder().withMonitored(true).withMonitorTaskInterval(DEFAULT_TEST_MONITOR_TASK_INTERVAL)));
        failoverPolicy.addListener((FailoverListener)((RetryListener)itemSourceDelegate -> false));
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Mockito.when((Object)failoverPolicy.createExecutor(ArgumentMatchers.anyString())).thenReturn((Object)executorService);
        failoverPolicy.start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ChronicleMapRetryFailoverPolicy.MetricsPrinter.class);
        ((ScheduledExecutorService)Mockito.verify((Object)executorService)).scheduleAtFixedRate((Runnable)captor.capture(), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)DEFAULT_TEST_MONITOR_TASK_INTERVAL), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void lifecycleStart() throws IOException {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        lifeCycle.start();
        Assert.assertFalse((boolean)lifeCycle.isStopped());
        Assert.assertTrue((boolean)lifeCycle.isStarted());
    }

    @Test
    public void lifecycleStop() throws IOException {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        lifeCycle.start();
        Assert.assertTrue((boolean)lifeCycle.isStarted());
        lifeCycle.stop();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        Assert.assertTrue((boolean)lifeCycle.isStopped());
    }

    @Test
    public void lifecycleStartStartsFailoverPolicyOnlyOnce() throws IOException {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)((ChronicleMapRetryFailoverPolicy)lifeCycle));
        DelayedShutdown delayedShutdown = (DelayedShutdown)Mockito.spy((Object)new DelayedShutdown(() -> {}));
        Mockito.when((Object)failoverPolicy.delayedShutdown()).thenReturn((Object)delayedShutdown);
        failoverPolicy.start();
        failoverPolicy.start();
        ((ChronicleMapRetryFailoverPolicy)Mockito.verify((Object)failoverPolicy)).delayedShutdown();
    }

    @Test
    public void lifecycleStopStopsFailoverPolicyOnlyOnce() throws IOException {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)((ChronicleMapRetryFailoverPolicy)lifeCycle));
        DelayedShutdown delayedShutdown = (DelayedShutdown)Mockito.spy((Object)new DelayedShutdown(() -> {}));
        Mockito.when((Object)failoverPolicy.delayedShutdown()).thenReturn((Object)delayedShutdown);
        failoverPolicy.start();
        Assert.assertTrue((boolean)failoverPolicy.isStarted());
        failoverPolicy.stop();
        failoverPolicy.stop();
        ((ChronicleMapRetryFailoverPolicy)Mockito.verify((Object)failoverPolicy)).stop(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void lifecycleStopWithTimeoutStopsFailoverPolicyOnlyOnce() throws IOException {
        LifeCycle lifeCycle = this.createLifeCycleTestObject();
        Assert.assertFalse((boolean)lifeCycle.isStarted());
        ChronicleMapRetryFailoverPolicy failoverPolicy = (ChronicleMapRetryFailoverPolicy)Mockito.spy((Object)((ChronicleMapRetryFailoverPolicy)lifeCycle));
        InvocationCounter counter = new InvocationCounter();
        DelayedShutdown delayedShutdown = (DelayedShutdown)Mockito.spy((Object)new DelayedShutdown(() -> counter.increment()));
        Mockito.when((Object)failoverPolicy.delayedShutdown()).thenReturn((Object)delayedShutdown);
        failoverPolicy.start();
        Assert.assertTrue((boolean)failoverPolicy.isStarted());
        failoverPolicy.stop(0L, false);
        failoverPolicy.stop(0L, false);
        Assert.assertEquals((long)1L, (long)counter.count.get());
    }

    @Test
    public void lifecycleStopWithTimeoutClosesGivenMap() throws IOException {
        String fileName = this.createTempFile().getAbsolutePath();
        ChronicleMap<CharSequence, ItemSource> failedItems = this.createDefaultTestChronicleMap();
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder(fileName, failedItems).withKeySequenceSelector(this.createDummyKeySequenceSelector());
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        failoverPolicy.addListener((FailoverListener)((RetryListener)failedItemSource -> true));
        failoverPolicy.start();
        Assert.assertTrue((boolean)failoverPolicy.isStarted());
        failoverPolicy.stop(1000L, false);
        ((ChronicleMap)Mockito.verify(failedItems)).close();
    }

    @Test
    public void lifecycleStopWithTimeoutClosesGivenKeySequenceSelector() throws IOException {
        String fileName = this.createTempFile().getAbsolutePath();
        ChronicleMap<CharSequence, ItemSource> failedItems = this.createDefaultTestChronicleMap();
        KeySequenceSelector keySequenceSelector = (KeySequenceSelector)Mockito.spy((Object)this.createDummyKeySequenceSelector());
        ChronicleMapRetryFailoverPolicy.Builder builder = this.createDefaultTestFailoverPolicyBuilder(fileName, failedItems).withKeySequenceSelector(keySequenceSelector);
        ChronicleMapRetryFailoverPolicy failoverPolicy = builder.build();
        failoverPolicy.addListener((FailoverListener)((RetryListener)failedItemSource -> true));
        failoverPolicy.start();
        Assert.assertTrue((boolean)failoverPolicy.isStarted());
        failoverPolicy.stop(100L, false);
        ((KeySequenceSelector)Mockito.verify((Object)keySequenceSelector)).close();
    }

    public KeySequenceSelector createDummyKeySequenceSelector() {
        return new KeySequenceSelector(){
            KeySequence keySequence = UUIDSequenceTest.createDefaultTestKeySequence();

            public Supplier<KeySequence> currentKeySequence() {
                return () -> this.keySequence;
            }

            public KeySequence firstAvailable() {
                return this.keySequence;
            }

            public KeySequenceSelector withRepository(KeySequenceConfigRepository keySequenceConfigRepository) {
                return null;
            }

            public void close() {
            }
        };
    }

    @NotNull
    public KeySequenceSelector createMockKeySequenceSelector() {
        KeySequenceSelector keySequenceSelector = (KeySequenceSelector)Mockito.mock(KeySequenceSelector.class);
        Mockito.when((Object)keySequenceSelector.firstAvailable()).thenReturn(Mockito.mock(KeySequence.class));
        return keySequenceSelector;
    }

    @NotNull
    public ChronicleMap<CharSequence, ItemSource> createDefaultTestChronicleMap() {
        ChronicleMap failedItems = (ChronicleMap)Mockito.mock(ChronicleMap.class);
        KeySequence sequence = UUIDSequenceTest.createDefaultTestKeySequence();
        KeySequenceConfig config = (KeySequenceConfig)Mockito.spy((Object)sequence.getConfig(true));
        CharSequence sequenceConfigKey = config.getKey();
        ArrayList<CharSequence> keySequenceConfigKeys = new ArrayList<CharSequence>();
        keySequenceConfigKeys.add(sequenceConfigKey);
        Mockito.when((Object)failedItems.get(ArgumentMatchers.eq((Object)KeySequenceConfigRepository.INDEX_KEY_NAME))).thenReturn((Object)new KeySequenceConfigKeys(keySequenceConfigKeys));
        Mockito.when((Object)failedItems.get(ArgumentMatchers.eq((Object)sequenceConfigKey))).thenReturn((Object)config);
        return failedItems;
    }

    private LifeCycle createLifeCycleTestObject() throws IOException {
        ChronicleMapRetryFailoverPolicy failoverPolicy = this.createDefaultTestFailoverPolicyBuilder().withKeySequenceSelector(this.createDefaultTestKeySequenceSelector()).build();
        failoverPolicy.addListener((FailoverListener)((RetryListener)itemSourceDelegate -> false));
        return failoverPolicy;
    }

    public ChronicleMapRetryFailoverPolicy.Builder createDefaultTestFailoverPolicyBuilder() throws IOException {
        File tempFile = this.createTempFile();
        return ChronicleMapRetryFailoverPolicy.newBuilder().withKeySequenceSelector(this.createDefaultTestKeySequenceSelector()).withFileName(tempFile.getAbsolutePath()).withNumberOfEntries(100L);
    }

    public ChronicleMapRetryFailoverPolicy.Builder createDefaultTestFailoverPolicyBuilder(String fileName, final ChronicleMap<CharSequence, ItemSource> failedItems) {
        return new ChronicleMapRetryFailoverPolicy.Builder(){

            ChronicleMap<CharSequence, ItemSource> createChronicleMap() {
                return failedItems;
            }
        }.withFileName(fileName).withNumberOfEntries(100L).withKeySequenceSelector(this.createMockKeySequenceSelector());
    }

    private KeySequenceSelector createDefaultTestKeySequenceSelector() {
        return new SingleKeySequenceSelector(1L);
    }

    private File createTempFile() throws IOException {
        File tempFile = File.createTempFile("failedItems", "test");
        tempFile.deleteOnExit();
        return tempFile;
    }

    static class ExceptionMatcher
    extends BaseMatcher<Throwable> {
        private final Class expectedType;
        private final String expectedMessage;

        public ExceptionMatcher(Class expectedType, String expectedMessage) {
            this.expectedType = expectedType;
            this.expectedMessage = expectedMessage;
        }

        public boolean matches(Object item) {
            return this.expectedType == item.getClass();
        }

        public void describeTo(Description description) {
        }
    }

    static class ExceptionCauseMatcher
    extends BaseMatcher<Throwable> {
        final Exception expectedCause;

        public ExceptionCauseMatcher(Exception testException) {
            this.expectedCause = testException;
        }

        public boolean matches(Object item) {
            return this.expectedCause.equals(item);
        }

        public void describeTo(Description description) {
        }
    }

    private class InvocationCounter {
        private AtomicInteger count = new AtomicInteger();

        private InvocationCounter() {
        }

        public void increment() {
            this.count.incrementAndGet();
        }
    }
}

