/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.appenders.log4j2.elasticsearch.ByteBufItemSource;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemMarshaller;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.thirdparty.ReusableByteBufOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FailedItemMarshallerTest {
    @Test
    public void defaultConstructorCreatesObjectMapper() {
        final ObjectMapper configuredObjectMapper = new ObjectMapper();
        final AtomicInteger callCount = new AtomicInteger();
        new FailedItemMarshaller(){

            ObjectMapper createConfiguredObjectMapper() {
                callCount.incrementAndGet();
                return configuredObjectMapper;
            }
        };
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void readResolveCreatesMapperOnlyOnce() {
        final ObjectMapper configuredObjectMapper = new ObjectMapper();
        final AtomicInteger callCount = new AtomicInteger();
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller(){

            ObjectMapper createConfiguredObjectMapper() {
                callCount.incrementAndGet();
                return configuredObjectMapper;
            }
        };
        failedItemMarshaller.readResolve();
        failedItemMarshaller.readResolve();
        Assert.assertEquals((long)1L, (long)callCount.get());
    }

    @Test
    public void returnedObjectMapperIsACopyOfInternalMapper() {
        final ObjectMapper configuredObjectMapper = new ObjectMapper();
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller(){

            ObjectMapper createConfiguredObjectMapper() {
                return configuredObjectMapper;
            }
        };
        ObjectMapper result = failedItemMarshaller.objectMapper();
        Assert.assertNotSame((Object)configuredObjectMapper, (Object)result);
    }

    @Test
    public void readDoesNotRethrow() {
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller();
        Bytes bytes = (Bytes)Mockito.mock(Bytes.class);
        RuntimeException expectedException = (RuntimeException)Mockito.spy((Object)new RuntimeException("test exception"));
        Mockito.when((Object)bytes.inputStream()).thenThrow(new Throwable[]{expectedException});
        failedItemMarshaller.read(bytes, null);
        ((RuntimeException)Mockito.verify((Object)expectedException, (VerificationMode)Mockito.times((int)1))).getMessage();
    }

    @Test
    public void writeDoesNotRethrow() {
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller();
        Bytes bytes = (Bytes)Mockito.mock(Bytes.class);
        RuntimeException expectedException = (RuntimeException)Mockito.spy((Object)new RuntimeException("test exception"));
        Mockito.when((Object)bytes.outputStream()).thenThrow(new Throwable[]{expectedException});
        failedItemMarshaller.write(bytes, (ItemSource)Mockito.mock(ItemSource.class));
        ((RuntimeException)Mockito.verify((Object)expectedException, (VerificationMode)Mockito.times((int)1))).getMessage();
    }

    @Test
    public void readMarshallableHasNoSideEffects() {
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller();
        WireIn wireIn = (WireIn)Mockito.mock(WireIn.class);
        failedItemMarshaller.readMarshallable(wireIn);
        Mockito.verifyZeroInteractions((Object[])new Object[]{wireIn});
    }

    @Test
    public void writeMarshallableHasNoSideEffects() {
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller();
        WireOut wireOut = (WireOut)Mockito.mock(WireOut.class);
        failedItemMarshaller.writeMarshallable(wireOut);
        Mockito.verifyZeroInteractions((Object[])new Object[]{wireOut});
    }

    @Test
    public void jacksonInjectedReleaseCallbackDoesNotThrow() throws IOException {
        FailedItemMarshaller failedItemMarshaller = new FailedItemMarshaller();
        CompositeByteBuf byteBuf = new CompositeByteBuf((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, false, 2).capacity(1024);
        ByteBufItemSource itemSource = new ByteBufItemSource((ByteBuf)byteBuf, source -> {});
        FailedItemSource failedItemSource = new FailedItemSource((ItemSource)itemSource, new FailedItemInfo(UUID.randomUUID().toString()));
        ReusableByteBufOutputStream outputStream = new ReusableByteBufOutputStream((ByteBuf)byteBuf);
        failedItemMarshaller.objectMapper().writeValue((OutputStream)outputStream, (Object)failedItemSource);
        Bytes in = (Bytes)Mockito.mock(Bytes.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteBuf.array());
        Mockito.when((Object)in.inputStream()).thenReturn((Object)inputStream);
        FailedItemSource deserialized = (FailedItemSource)failedItemMarshaller.read(in, null);
        deserialized.release();
    }
}

