/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.UUID;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FailedItemSourceTest {
    @Test
    public void getSourceDelegatesToItemSource() {
        FailedItemInfo failedItemInfo = (FailedItemInfo)Mockito.mock(FailedItemInfo.class);
        StringItemSource itemSource = (StringItemSource)Mockito.mock(StringItemSource.class);
        FailedItemSource failedItemSource = new FailedItemSource((ItemSource)itemSource, failedItemInfo);
        String expectedSource = UUID.randomUUID().toString();
        Mockito.when((Object)itemSource.getSource()).thenReturn((Object)expectedSource);
        String result = (String)failedItemSource.getSource();
        Assert.assertEquals((Object)expectedSource, (Object)result);
    }

    @Test
    public void releaseDelegatesToItemSource() {
        FailedItemInfo failedItemInfo = (FailedItemInfo)Mockito.mock(FailedItemInfo.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(ItemSource.class);
        FailedItemSource failedItemSource = new FailedItemSource(itemSource, failedItemInfo);
        failedItemSource.release();
        ((ItemSource)Mockito.verify((Object)itemSource, (VerificationMode)Mockito.times((int)1))).release();
    }

    @Test
    public void targetNameCanBeRetrieved() {
        String expectedTargetName = UUID.randomUUID().toString();
        FailedItemInfo failedItemInfo = new FailedItemInfo(expectedTargetName);
        FailedItemSource failedItemSource = new FailedItemSource((ItemSource)Mockito.mock(ItemSource.class), failedItemInfo);
        Assert.assertEquals((Object)expectedTargetName, (Object)failedItemSource.getInfo().getTargetName());
    }
}

