/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.openhft.chronicle.map.ChronicleMap;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeys;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KeySequenceConfigRepositoryTest {
    static final int DEFAULT_OFFSET = 100;
    static final int SEQ_ID_OFFSET = 100;
    static final long DEFAULT_TEST_KEY_SEQUENCE_EXPIRY = 1000L;
    private static int offsetMultiplier = 1;
    private static Random random = new Random();

    @Test
    public void keySequenceConfigListIsCreatedIfItIsAbsentInGivenMap() {
        ChronicleMap failedItems = (ChronicleMap)Mockito.mock(ChronicleMap.class);
        Mockito.when((Object)failedItems.containsKey(ArgumentMatchers.eq((Object)KeySequenceConfigRepository.INDEX_KEY_NAME))).thenReturn((Object)false);
        new KeySequenceConfigRepository((Map)failedItems, 1000L);
        ArgumentCaptor configRegistryCaptor = ArgumentCaptor.forClass(KeySequenceConfigKeys.class);
        ((ChronicleMap)Mockito.verify((Object)failedItems)).put(ArgumentMatchers.eq((Object)KeySequenceConfigRepository.INDEX_KEY_NAME), configRegistryCaptor.capture());
        Assert.assertNotNull((Object)configRegistryCaptor.getValue());
    }

    @Test
    public void keySequenceRegistryIsReusedIfItIsAlreadyPresentInGivenMap() {
        ChronicleMap failedItems = (ChronicleMap)Mockito.mock(ChronicleMap.class);
        Mockito.when((Object)failedItems.containsKey(ArgumentMatchers.eq((Object)KeySequenceConfigRepository.INDEX_KEY_NAME))).thenReturn((Object)true);
        new KeySequenceConfigRepository((Map)failedItems, 1000L);
        ((ChronicleMap)Mockito.verify((Object)failedItems, (VerificationMode)Mockito.never())).put(ArgumentMatchers.eq((Object)KeySequenceConfigRepository.INDEX_KEY_NAME), ArgumentMatchers.any());
    }

    @Test
    public void getReturnsElementIfPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig expected = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        map.put(expected.getKey(), (ItemSource)expected);
        KeySequenceConfig result = repository.get(expected.getKey());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void getReturnsNullIfElementNotPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig result = repository.get((CharSequence)UUID.randomUUID().toString());
        Assert.assertNull((Object)result);
    }

    @Test
    public void containsReturnsTrueIfElementPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig expected = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        map.put(expected.getKey(), (ItemSource)expected);
        boolean result = repository.contains(expected.getKey());
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void containsReturnsFalseIfElementNotPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        boolean result = repository.contains((CharSequence)UUID.randomUUID().toString());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void persistRegistersNewKeySequenceConfigKeyIfNotPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        repository.persist(config);
        KeySequenceConfigKeys keys = (KeySequenceConfigKeys)map.get(KeySequenceConfigRepository.INDEX_KEY_NAME);
        Assert.assertTrue((boolean)keys.getSource().getKeys().contains(expectedKey));
    }

    @Test
    public void persistDoesNotRegisterNewKeySequenceConfigKeyIfAlreadyPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = (KeySequenceConfigRepository)Mockito.spy((Object)new KeySequenceConfigRepository(map, 1000L));
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        map.put(expectedKey, (ItemSource)config);
        KeySequenceConfigKeys keys = (KeySequenceConfigKeys)map.get(KeySequenceConfigRepository.INDEX_KEY_NAME);
        Assert.assertFalse((boolean)keys.getSource().getKeys().contains(expectedKey));
        repository.persist(config);
        ((KeySequenceConfigRepository)Mockito.verify((Object)repository, (VerificationMode)Mockito.never())).registerKeySequenceConfig((CharSequence)ArgumentMatchers.eq((Object)expectedKey));
    }

    @Test
    public void persistStoresKeySequenceConfigIfNotPresentInGivenMap() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        repository.persist(config);
        Assert.assertEquals((Object)config, map.get(expectedKey));
    }

    @Test
    public void purgeUnregistersKeySequenceConfigKey() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = (KeySequenceConfigRepository)Mockito.spy((Object)new KeySequenceConfigRepository(map, 1000L));
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        repository.persist(config);
        CharSequence nonExpectedKey = config.getKey();
        KeySequenceConfigKeys keys = (KeySequenceConfigKeys)map.get(KeySequenceConfigRepository.INDEX_KEY_NAME);
        Assert.assertTrue((boolean)keys.getSource().getKeys().contains(nonExpectedKey));
        repository.purge(config);
        ((KeySequenceConfigRepository)Mockito.verify((Object)repository)).unregisterKeySequenceConfig((CharSequence)ArgumentMatchers.eq((Object)nonExpectedKey));
        Assert.assertFalse((boolean)keys.getSource().getKeys().contains(nonExpectedKey));
    }

    @Test
    public void purgeRemovesKeySequenceConfig() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = (KeySequenceConfigRepository)Mockito.spy((Object)new KeySequenceConfigRepository(map, 1000L));
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        repository.persist(config);
        CharSequence nonExpectedKey = config.getKey();
        Assert.assertTrue((boolean)map.keySet().contains(nonExpectedKey));
        repository.purge(config);
        Assert.assertFalse((boolean)map.keySet().contains(nonExpectedKey));
    }

    @Test
    public void getAllReturnsOnlyRegisteredKeySequenceConfigs() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = (KeySequenceConfigRepository)Mockito.spy((Object)new KeySequenceConfigRepository(map, 1000L));
        KeySequenceConfig config1 = this.createTestKeySequenceConfig();
        KeySequenceConfig config2 = this.createTestKeySequenceConfig();
        KeySequenceConfig config3 = this.createTestKeySequenceConfig();
        repository.persist(config1);
        repository.persist(config2);
        map.put(config3.getKey(), (ItemSource)config3);
        Collection configs = repository.getAll();
        Assert.assertTrue((boolean)configs.contains(config1));
        Assert.assertTrue((boolean)configs.contains(config2));
        Assert.assertFalse((boolean)configs.contains(config3));
    }

    @Test
    public void persistSetsExpiryMillis() {
        long minimumExpectedExpiry = 11000L;
        System.setProperty("appenders.failover.keysequence.expireInMillis", String.valueOf(minimumExpectedExpiry));
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        repository.persist(config);
        KeySequenceConfig result = (KeySequenceConfig)map.get(expectedKey);
        Assert.assertTrue((System.currentTimeMillis() + minimumExpectedExpiry >= result.getExpireAt() ? 1 : 0) != 0);
    }

    @Test
    public void persistSetsProvidedExpiryIfProvidedWasLowerThanDefault() {
        long defaultExpiry = 20000L;
        System.setProperty("appenders.failover.keysequence.expireInMillis", String.valueOf(defaultExpiry));
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        long providedExpiry = 15000L;
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, providedExpiry);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        repository.persist(config);
        KeySequenceConfig result = (KeySequenceConfig)map.get(expectedKey);
        Assert.assertTrue((System.currentTimeMillis() + providedExpiry >= result.getExpireAt() ? 1 : 0) != 0);
        Assert.assertTrue((System.currentTimeMillis() + defaultExpiry > result.getExpireAt() - providedExpiry ? 1 : 0) != 0);
    }

    @Test
    public void persistSetsGivenExpiryIfHigherThanDefault() {
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        long minimumExpectedExpiry = 20000L;
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, minimumExpectedExpiry);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        CharSequence expectedKey = config.getKey();
        repository.persist(config);
        KeySequenceConfig result = (KeySequenceConfig)map.get(expectedKey);
        Assert.assertTrue((System.currentTimeMillis() + minimumExpectedExpiry >= result.getExpireAt() ? 1 : 0) != 0);
    }

    @Test
    public void consistencyCheckReturnsTrueIfKeySequenceConfigOwned() {
        System.setProperty("appenders.failover.keysequence.expireInMillis", "0");
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        repository.persist(config);
        boolean result = repository.consistencyCheck(config);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void consistencyCheckReturnsFalseIfKeySequenceConfigNotOwned() {
        System.setProperty("appenders.failover.keysequence.expireInMillis", "0");
        HashMap<CharSequence, ItemSource> map = this.createDefaultTestMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L);
        KeySequenceConfig config = this.createTestKeySequenceConfig();
        repository.persist(config);
        config.setOwnerId(KeySequenceConfigRepository.ID + 1L);
        map.put(config.getKey(), (ItemSource)config);
        boolean result = repository.consistencyCheck(config);
        Assert.assertFalse((boolean)result);
    }

    public KeySequenceConfig createTestKeySequenceConfig() {
        return new KeySequenceConfig(UUID.randomUUID().getMostSignificantBits(), 16L, 16L);
    }

    public HashMap<CharSequence, ItemSource> createDefaultTestMap() {
        return new HashMap<CharSequence, ItemSource>();
    }

    public static KeySequenceConfig createDefaultTestKeySequenceConfig() {
        return new KeySequenceConfig((long)(random.nextInt(100) + 100 * offsetMultiplier++), 16L, 16L);
    }
}

