/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Random;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepositoryTest;
import org.junit.Assert;
import org.junit.Test;

public class KeySequenceConfigTest {
    private static final long DEFAULT_TEST_SEQUENCE_ID = 1L;

    @Test
    public void toStringShowsNecessaryInfo() throws IOException {
        KeySequenceConfig keySequenceConfig = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        String result = keySequenceConfig.toString();
        KeySequenceConfigInfo info = (KeySequenceConfigInfo)new ObjectMapper().readValue(result, KeySequenceConfigInfo.class);
        Assert.assertEquals((Object)keySequenceConfig.getClass().getSimpleName(), (Object)info.cls);
        Assert.assertEquals((long)keySequenceConfig.getSeqId(), (long)info.seqId);
        Assert.assertEquals((long)keySequenceConfig.nextReaderIndex(), (long)info.rIdx);
        Assert.assertEquals((long)keySequenceConfig.nextWriterIndex(), (long)info.wIdx);
    }

    @Test
    public void equalsReturnsFalseIfNullProvided() {
        KeySequenceConfig keySequenceConfig = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        boolean result = keySequenceConfig.equals(null);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfWrongTypeProvided() {
        KeySequenceConfig keySequenceConfig = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        Object object = new Object();
        boolean result = keySequenceConfig.equals(object);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfSequenceIdsAreDifferent() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(2L, 16L, 16L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfOwnerIdsAreDifferent() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig1.setOwnerId(1L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig2.setOwnerId(2L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfReaderKeysAreDifferent() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(1L, 17L, 16L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfWriterKeysAreDifferent() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(1L, 16L, 17L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfExpiriesAreDifferent() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig1.setExpireAt(1L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig2.setExpireAt(2L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsTrueIfOtherStateIsEqual() {
        KeySequenceConfig keySequenceConfig1 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig1.setOwnerId(1L);
        keySequenceConfig1.setExpireAt(1L);
        KeySequenceConfig keySequenceConfig2 = new KeySequenceConfig(1L, 16L, 16L);
        keySequenceConfig2.setOwnerId(1L);
        keySequenceConfig2.setExpireAt(1L);
        boolean result = keySequenceConfig1.equals((Object)keySequenceConfig2);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void hashCodeReturnsValidValues() {
        KeySequenceConfig config = new KeySequenceConfig(1L, 16L, 16L);
        Random random = new Random();
        for (int i = 0; i < 10000; ++i) {
            config.setExpireAt(random.nextLong());
            Assert.assertNotEquals((long)0L, (long)config.hashCode());
        }
    }

    static class KeySequenceConfigInfo {
        public long seqId;
        public long rIdx;
        public long wIdx;
        public String cls;

        KeySequenceConfigInfo() {
        }
    }
}

