/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.log4j2.elasticsearch.failover.Log4j2SingleKeySequenceSelector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class Log4j2SingleKeySequenceSelectorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void builderBuildsSuccessfully() {
        Log4j2SingleKeySequenceSelector.Builder builder = Log4j2SingleKeySequenceSelector.newBuilder().withSequenceId(1L);
        Log4j2SingleKeySequenceSelector keySequenceSelector = builder.build();
        Assert.assertNotNull((Object)keySequenceSelector);
    }

    @Test
    public void builderThrowsOnSequenceIdLowerThanZero() {
        Log4j2SingleKeySequenceSelector.Builder builder = Log4j2SingleKeySequenceSelector.newBuilder().withSequenceId(-1L);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("sequenceId must be higher than 0");
        builder.build();
    }

    @Test
    public void builderThrowsOnSequenceIdEqualZero() {
        Log4j2SingleKeySequenceSelector.Builder builder = Log4j2SingleKeySequenceSelector.newBuilder().withSequenceId(0L);
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage("sequenceId must be higher than 0");
        builder.build();
    }
}

