/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.openhft.chronicle.map.ChronicleMap;
import org.appenders.log4j2.elasticsearch.ByteBufItemSource;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.ChronicleMapRetryFailoverPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeys;
import org.junit.Assert;
import org.junit.Test;

public class MarshallingTest {
    private Random random = new Random();

    @Test
    public void canMarshallKeySequenceConfig() throws IOException {
        ChronicleMap<CharSequence, ItemSource> map = this.createDefaultTestChronicleMap();
        long expectedSeqId = this.randomLong();
        long expectedOwnerId = this.randomLong();
        long expectedReaderIndex = this.randomLong();
        long expectedWriterIndex = this.randomLong();
        KeySequenceConfig config = new KeySequenceConfig(expectedSeqId, expectedReaderIndex, expectedWriterIndex);
        config.setOwnerId(expectedOwnerId);
        CharSequence expectedId = config.getKey();
        map.put((Object)config.getKey(), (Object)config);
        KeySequenceConfig result = (KeySequenceConfig)map.get((Object)config.getKey());
        Assert.assertEquals((Object)expectedId, (Object)result.getKey());
        Assert.assertEquals((long)expectedOwnerId, (long)result.getOwnerId());
        Assert.assertEquals((long)expectedSeqId, (long)result.getSeqId());
        Assert.assertEquals((long)expectedReaderIndex, (long)result.nextReaderIndex());
        Assert.assertEquals((long)expectedWriterIndex, (long)result.nextWriterIndex());
    }

    @Test
    public void canMarshallKeySequenceConfigList() throws IOException {
        ChronicleMap<CharSequence, ItemSource> map = this.createDefaultTestChronicleMap();
        ArrayList<String> keys = new ArrayList<String>();
        String key1 = UUID.randomUUID().toString();
        String key2 = UUID.randomUUID().toString();
        keys.add(key1);
        keys.add(key2);
        KeySequenceConfigKeys expected = new KeySequenceConfigKeys(keys);
        String expectedKey = UUID.randomUUID().toString();
        map.put((Object)expectedKey, (Object)expected);
        KeySequenceConfigKeys result = (KeySequenceConfigKeys)map.get((Object)expectedKey);
        List source = result.getSource().getKeys();
        Assert.assertTrue((boolean)source.contains(key1));
        Assert.assertTrue((boolean)source.contains(key2));
    }

    @Test
    public void canMarshallFailedItemSource() throws IOException {
        CompositeByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.compositeHeapBuffer(2);
        byte[] bytes = new byte[512];
        this.random.nextBytes(bytes);
        String expectedPayload = new String(bytes, Charset.defaultCharset());
        byteBuf.writeBytes(bytes);
        Assert.assertEquals((Object)expectedPayload, (Object)byteBuf.toString(Charset.defaultCharset()));
        ByteBufItemSource expectedSource = new ByteBufItemSource((ByteBuf)byteBuf, source -> byteBuf.release());
        String targetName = UUID.randomUUID().toString();
        FailedItemSource failedItemSource = new FailedItemSource((ItemSource)expectedSource, new FailedItemInfo(targetName));
        ChronicleMap<CharSequence, ItemSource> map = this.createDefaultTestChronicleMap();
        String key = UUID.randomUUID().toString();
        map.put((Object)key, (Object)failedItemSource);
        FailedItemSource result = (FailedItemSource)map.get((Object)key);
        Assert.assertEquals((Object)expectedPayload, (Object)((ByteBuf)result.getSource()).toString(Charset.defaultCharset()));
        Assert.assertEquals((Object)failedItemSource.getInfo().getTargetName(), (Object)result.getInfo().getTargetName());
    }

    private ChronicleMap<CharSequence, ItemSource> createDefaultTestChronicleMap() throws IOException {
        File file = this.createTempFile();
        return new ChronicleMapRetryFailoverPolicy.Builder().withFileName(file.getAbsolutePath()).withNumberOfEntries(10L).withAverageValueSize(1024).withBatchSize(1).createChronicleMap();
    }

    private File createTempFile() {
        try {
            return File.createTempFile("test", ".chronicleMap");
        }
        catch (IOException e) {
            Assert.fail((String)"Cannot create temp file");
            return null;
        }
    }

    private long randomLong() {
        return Math.abs(this.random.nextLong());
    }

    static {
        System.setProperty("io.netty.allocator.maxOrder", "1");
    }
}

