/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.RetryListener;
import org.appenders.log4j2.elasticsearch.failover.RetryProcessor;
import org.appenders.log4j2.elasticsearch.failover.SingleKeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.UUIDSequence;
import org.appenders.log4j2.elasticsearch.failover.UUIDSequenceTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RetryProcessorTest {
    public static final int DEFAULT_TEST_MAX_RETRY_SIZE = 10;
    private Random random = new Random();

    @Before
    public void setup() {
        System.setProperty("appenders.retry.backoff.millis", "0");
    }

    @Test
    public void runnableRunDelegatesToRetryBatch() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(ItemSource.class);
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, 0, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = (RetryProcessor)Mockito.spy((Object)this.createRetryProcessor(10, items, keySequenceSelector, listeners));
        retryProcessor.run();
        ((RetryProcessor)Mockito.verify((Object)retryProcessor)).retry();
    }

    @Test
    public void exceptionsAreNotRethrown() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        NullPointerException expectedException = (NullPointerException)Mockito.spy((Object)new NullPointerException("test exception"));
        Mockito.when((Object)listener.notify(ArgumentMatchers.any())).thenThrow(new Throwable[]{expectedException});
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int expectedSize = 1;
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, expectedSize, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(expectedSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener)).notify(ArgumentMatchers.any(FailedItemSource.class));
        ((NullPointerException)Mockito.verify((Object)expectedException)).getMessage();
    }

    @Test
    public void retryReturnsGracefullyIfKeySequenceIsNull() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = (KeySequenceSelector)Mockito.mock(KeySequenceSelector.class);
        Mockito.when((Object)keySequenceSelector.firstAvailable()).thenReturn(null);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(10, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).notify(ArgumentMatchers.any());
    }

    @Test
    public void doesNotRetryWhenMapIsEmpty() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int maxRetryBatchSize = 10;
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, 0, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(maxRetryBatchSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)0))).notify(ArgumentMatchers.any(FailedItemSource.class));
    }

    @Test
    public void retryListSizeIsConfigurable() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int maxRetryBatchSize = 10;
        int mapSize = maxRetryBatchSize * 2;
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, mapSize, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(maxRetryBatchSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)maxRetryBatchSize))).notify(ArgumentMatchers.any(FailedItemSource.class));
    }

    @Test
    public void retryListSizeIsLowerThanMaxSizeIfNumberOfAvailableElementsIsLowerThanMaxSize() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int maxRetryBatchSize = 10;
        int mapSize = maxRetryBatchSize / 2;
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, mapSize, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(maxRetryBatchSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)mapSize))).notify(ArgumentMatchers.any(FailedItemSource.class));
    }

    @Test
    public void retryListSizeIsLowerThanNumberOfAvailableElementsIfElementsAreNull() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int maxRetryBatchSize = 10;
        int mapSize = maxRetryBatchSize / 2;
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, mapSize, keySequenceSelector, () -> itemSource);
        UUIDSequence keySequence = new UUIDSequence(UUIDSequenceTest.createDefaultTestKeySequenceConfig());
        keySequence.nextWriterKey();
        items.remove(keySequence.nextReaderKey());
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(maxRetryBatchSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)(mapSize - 1)))).notify(ArgumentMatchers.any(FailedItemSource.class));
        Assert.assertEquals((long)1L, (long)retryProcessor.orphanedKeyCount.get());
    }

    @Test
    public void waitsIfBackoffMillisConfigured() {
        System.setProperty("appenders.retry.backoff.millis", "100");
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(ItemSource.class);
        int sequenceId = this.random.nextInt(1000) + 16;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(sequenceId, items);
        RetryProcessorTest.fillMap(items, 1, keySequenceSelector, () -> itemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(10, items, keySequenceSelector, listeners);
        long start = System.currentTimeMillis();
        retryProcessor.run();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 100L ? 1 : 0) != 0);
    }

    @Test
    public void nonFailedItemSourceIsReleasedAndNotRetried() {
        RetryListener listener = (RetryListener)Mockito.mock(RetryListener.class);
        ItemSource itemSource = (ItemSource)Mockito.mock(FailedItemSource.class);
        int maxRetryBatchSize = 10;
        int mapSize = maxRetryBatchSize / 2;
        HashMap<CharSequence, ItemSource> items = new HashMap<CharSequence, ItemSource>();
        KeySequenceSelector keySequenceSelector = this.createDefaultTestKeySequenceSelector(1L, items);
        RetryProcessorTest.fillMap(items, mapSize, keySequenceSelector, () -> itemSource);
        UUIDSequence keySequence = new UUIDSequence(UUIDSequenceTest.createDefaultTestKeySequenceConfig());
        keySequence.nextWriterKey();
        ItemSource invalidItemSource = (ItemSource)Mockito.mock(ItemSource.class);
        CharSequence readerKey = keySequence.nextReaderKey();
        items.put(readerKey, invalidItemSource);
        RetryListener[] listeners = new RetryListener[]{listener};
        RetryProcessor retryProcessor = this.createRetryProcessor(maxRetryBatchSize, items, keySequenceSelector, listeners);
        retryProcessor.retry();
        ((RetryListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)(mapSize - 1)))).notify(ArgumentMatchers.any(FailedItemSource.class));
        ((ItemSource)Mockito.verify((Object)invalidItemSource)).release();
    }

    static Map<CharSequence, ItemSource> fillMap(Map<CharSequence, ItemSource> map, int expectedSize, KeySequenceSelector keySequenceSelector, Supplier<ItemSource> itemSourceSupplier) {
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        for (int i = 0; i < expectedSize; ++i) {
            map.put(keySequence.nextWriterKey(), itemSourceSupplier.get());
        }
        new KeySequenceConfigRepository(map).persist(keySequence.getConfig(true));
        return map;
    }

    public KeySequenceSelector createDefaultTestKeySequenceSelector(long sequenceId, Map<CharSequence, ItemSource> items) {
        return new SingleKeySequenceSelector(1L).withRepository(new KeySequenceConfigRepository(items));
    }

    public RetryProcessor createRetryProcessor(int expectedSize, Map<CharSequence, ItemSource> items, KeySequenceSelector keySequenceSelector, RetryListener[] listeners) {
        return new RetryProcessor(expectedSize, items, listeners, keySequenceSelector);
    }
}

