/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.locks.LockSupport;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepositoryTest;
import org.appenders.log4j2.elasticsearch.failover.SingleKeySequenceSelector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SingleKeySequenceSelectorTest {
    static final int DEFAULT_TEST_SEQUENCE_ID = 1;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void keySequenceIsReusedAfterFirstCall() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        this.sleep(1);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId());
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence1 = keySequenceSelector.firstAvailable();
        KeySequence keySequence2 = keySequenceSelector.firstAvailable();
        KeySequenceConfig config1 = keySequence1.getConfig(true);
        KeySequenceConfig config2 = keySequence2.getConfig(true);
        Assert.assertEquals((long)config.getSeqId(), (long)config1.getSeqId());
        Assert.assertEquals((long)config.getSeqId(), (long)config2.getSeqId());
        Assert.assertEquals((Object)config1.getKey(), (Object)config2.getKey());
        Assert.assertSame((Object)config1, (Object)config2);
    }

    @Test
    public void repositoryMustBeSet() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(1L);
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNotNull((Object)keySequence);
    }

    @Test
    public void throwsWhenRepositoryNotSet() {
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(1L);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(KeySequenceConfigRepository.class.getSimpleName() + " was not provided for " + SingleKeySequenceSelector.class.getSimpleName());
        keySequenceSelector.firstAvailable();
    }

    @Test
    public void newKeySequenceIsCreatedOnFirstCallIfNoConfigsAvailableInProvidedRepository() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(1L);
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNotNull((Object)keySequence);
        Assert.assertSame((Object)keySequence, keySequenceSelector.currentKeySequence().get());
    }

    @Test
    public void newKeySequenceIsCreatedOnFirstCallIfNoMatchingKeySequenceIsAvailableInProvidedRepository() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId() + 1L);
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNotNull((Object)keySequence);
        Assert.assertSame((Object)keySequence, keySequenceSelector.currentKeySequence().get());
    }

    @Test
    public void keySequenceIsReusedOnFirstCallIfThereIsAnExpiredKeySequenceWithMatchingSequenceIdInProvidedRepository() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        this.sleep(1);
        CharSequence expectedKey = config.getKey();
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(UUID.fromString((String)expectedKey).getMostSignificantBits());
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertEquals((Object)expectedKey, (Object)keySequence.getConfig(true).getKey());
    }

    @Test
    public void keySequenceIsReusedOnFirstCallIfThereIsAnExpiredAndNotOwnedKeySequenceWithMatchingSequenceIdInProvidedRepository() {
        HashMap<CharSequence, KeySequenceConfig> map = new HashMap<CharSequence, KeySequenceConfig>();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        this.sleep(1);
        CharSequence expectedKey = config.getKey();
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(UUID.fromString((String)expectedKey).getMostSignificantBits());
        keySequenceSelector.withRepository(repository);
        config.setOwnerId(KeySequenceConfigRepository.ID + 1L);
        map.put(config.getKey(), config);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertEquals((Object)expectedKey, (Object)keySequence.getConfig(true).getKey());
    }

    @Test
    public void keySequenceIsNotReusedOnFirstCallWhenMatchingNonExpiredAndNotOwnedKeySequenceFoundInProvidedRepository() {
        System.setProperty("appenders.failover.keysequence.consistencyCheckDelay", "1");
        HashMap<CharSequence, KeySequenceConfig> map = new HashMap<CharSequence, KeySequenceConfig>();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId());
        keySequenceSelector.withRepository(repository);
        config.setOwnerId(KeySequenceConfigRepository.ID + 1L);
        map.put(config.getKey(), config);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNull((Object)keySequence);
    }

    @Test
    public void keySequenceIsReusedOnFirstCallWhenMatchingNonExpiredAndOwnedKeySequenceFoundInProvidedRepository() {
        System.setProperty("appenders.failover.keysequence.consistencyCheckDelay", "1");
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        CharSequence expectedKey = config.getKey();
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId());
        keySequenceSelector.withRepository(repository);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertEquals((Object)expectedKey, (Object)keySequence.getConfig(true).getKey());
    }

    @Test
    public void newKeySequenceIsNotCreatedOnFirstCallWhenNotExpiredAndNotOwnedKeySequenceFoundInProvidedRepository() {
        System.setProperty("appenders.failover.keysequence.consistencyCheckDelay", "1");
        HashMap<CharSequence, KeySequenceConfig> map = new HashMap<CharSequence, KeySequenceConfig>();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 1000L);
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId());
        keySequenceSelector.withRepository(repository);
        int size = map.size();
        config.setOwnerId(KeySequenceConfigRepository.ID + 1L);
        map.put(config.getKey(), config);
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNull((Object)keySequence);
        Assert.assertEquals((long)size, (long)map.size());
    }

    @Test
    public void newKeySequenceIsNotCreatedOnFirstCallWhenConsistencyCheckFailed() {
        HashMap map = new HashMap();
        KeySequenceConfigRepository repository = new KeySequenceConfigRepository(map, 0L){

            boolean consistencyCheck(KeySequenceConfig config) {
                System.out.println("!!! Consistency check failed");
                return false;
            }
        };
        KeySequenceConfig config = KeySequenceConfigRepositoryTest.createDefaultTestKeySequenceConfig();
        repository.persist(config);
        this.sleep(1);
        SingleKeySequenceSelector keySequenceSelector = new SingleKeySequenceSelector(config.getSeqId());
        keySequenceSelector.withRepository(repository);
        int size = map.size();
        KeySequence keySequence = keySequenceSelector.firstAvailable();
        Assert.assertNull((Object)keySequence);
        Assert.assertEquals((long)size, (long)map.size());
    }

    private void sleep(int millis) {
        LockSupport.parkNanos(millis * 1000000);
    }
}

