/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.UUIDSequence;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class UUIDSequenceTest {
    public static final int DEFAULT_TEST_SEQ_ID = 1;
    public static final int EXPECTED_INITIAL_DIFF = 0;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void throwsOnInitialReaderIndexLowerThanReservedKeys() {
        KeySequenceConfig sequenceConfig = this.createDefaultTestReaderIndexConfig(15);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("readerIndex cannot be lower than");
        this.createDefaultTestUUIDSequence(sequenceConfig);
    }

    @Test
    public void throwsOnInitialWriterIndexLowerThanReservedKeys() {
        KeySequenceConfig sequenceConfig = new KeySequenceConfig(1L, 16L, 15L);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("writerIndex cannot be lower than");
        this.createDefaultTestUUIDSequence(sequenceConfig);
    }

    @Test
    public void equalsReturnsFalseIfNullProvided() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        boolean result = sequence.equals(null);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfWrongTypeProvided() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        boolean result = sequence.equals(Object.class);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsFalseIfSequenceIdsAreDifferent() {
        KeySequenceConfig config1 = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence1 = this.createDefaultTestUUIDSequence(config1);
        KeySequenceConfig config2 = new KeySequenceConfig(2L, 16L, 16L);
        UUIDSequence sequence2 = this.createDefaultTestUUIDSequence(config2);
        boolean result = sequence1.equals(sequence2);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void equalsReturnsTrueIfSequenceIdsAreEqual() {
        KeySequenceConfig config1 = new KeySequenceConfig(1L, 16L, 16L);
        UUIDSequence sequence1 = this.createDefaultTestUUIDSequence(config1);
        KeySequenceConfig config2 = new KeySequenceConfig(1L, 16L, 16L);
        UUIDSequence sequence2 = this.createDefaultTestUUIDSequence(config2);
        boolean result = sequence1.equals(sequence2);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void equalsReturnsTrueIfReaderIndicesAreDifferent() {
        KeySequenceConfig config1 = new KeySequenceConfig(1L, 16L, 16L);
        UUIDSequence sequence1 = this.createDefaultTestUUIDSequence(config1);
        KeySequenceConfig config2 = new KeySequenceConfig(1L, 17L, 16L);
        UUIDSequence sequence2 = this.createDefaultTestUUIDSequence(config2);
        boolean result = sequence1.equals(sequence2);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void hashCodesAreEqualWhenSequencesAreEqual() {
        KeySequenceConfig config1 = new KeySequenceConfig(1L, 16L, 16L);
        UUIDSequence sequence1 = this.createDefaultTestUUIDSequence(config1);
        KeySequenceConfig config2 = new KeySequenceConfig(1L, 17L, 17L);
        UUIDSequence sequence2 = this.createDefaultTestUUIDSequence(config2);
        Assert.assertTrue((boolean)sequence1.equals(sequence2));
        int hashCode1 = sequence1.hashCode();
        int hashCode2 = sequence1.hashCode();
        Assert.assertEquals((long)hashCode1, (long)hashCode2);
    }

    @Test
    public void equalsReturnsTrueIfWriterIndicesAreDifferent() {
        KeySequenceConfig config1 = new KeySequenceConfig(1L, 16L, 16L);
        UUIDSequence sequence1 = this.createDefaultTestUUIDSequence(config1);
        KeySequenceConfig config2 = new KeySequenceConfig(1L, 16L, 17L);
        UUIDSequence sequence2 = this.createDefaultTestUUIDSequence(config2);
        boolean result = sequence1.equals(sequence2);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void returnsNextWriterKeyExcludingCurrent() {
        String expectedFirstKey = this.getNextExpectedKey(17);
        String expectedSecondKey = this.getNextExpectedKey(18);
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        CharSequence key1 = sequence.nextWriterKey();
        CharSequence key2 = sequence.nextWriterKey();
        Assert.assertEquals((Object)expectedFirstKey, (Object)key1);
        Assert.assertEquals((Object)expectedSecondKey, (Object)key2);
    }

    @Test
    public void returnsNextReaderKeyExcludingCurrent() {
        String expectedFirstKey = this.getNextExpectedKey(17);
        String expectedSecondKey = this.getNextExpectedKey(18);
        KeySequenceConfig config = this.createDefaultTestWriterIndexConfig(18);
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        CharSequence key1 = sequence.nextReaderKey();
        CharSequence key2 = sequence.nextReaderKey();
        Assert.assertEquals((Object)expectedFirstKey, (Object)key1);
        Assert.assertEquals((Object)expectedSecondKey, (Object)key2);
    }

    @Test
    public void returnsNullReaderKeyIfReaderKeyEqualsInitialWriterKey() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        CharSequence readerKey1 = sequence.nextReaderKey();
        Assert.assertNull((Object)readerKey1);
    }

    @Test
    public void returnsNullReaderKeyIfReaderKeyEqualsWriterKey() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        CharSequence readerKey1 = sequence.nextReaderKey();
        CharSequence readerKey2 = sequence.nextReaderKey();
        Assert.assertNull((Object)readerKey1);
        Assert.assertNull((Object)readerKey2);
    }

    @Test
    public void returnsNullReaderKeyIfReaderKeyModifiedConcurrently() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        final KeySequence sequence = (KeySequence)Mockito.spy((Object)this.createDefaultTestUUIDSequence(config));
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Mockito.when((Object)sequence.readerKeysAvailable()).thenAnswer((Answer)new Answer<Long>(){
            private boolean firstCall = true;

            public Long answer(InvocationOnMock invocation) {
                if (this.firstCall) {
                    this.firstCall = false;
                    new Thread(() -> {
                        sequence.nextReaderKey();
                        countDownLatch.countDown();
                    }).run();
                }
                return 1L;
            }
        });
        sequence.nextWriterKey();
        CharSequence readerKey1 = sequence.nextReaderKey();
        Assert.assertNull((Object)readerKey1);
    }

    @Test
    public void diffReturnsZeroIfWriterIndexEqualsReaderIndex() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        long diff1 = sequence.readerKeysAvailable();
        sequence.nextWriterKey();
        sequence.nextReaderKey();
        long diff2 = sequence.readerKeysAvailable();
        Assert.assertEquals((long)0L, (long)diff1);
        Assert.assertEquals((long)0L, (long)diff2);
    }

    @Test
    public void diffDoesNotReturnZeroIfWriterIndexDoesNotEqualReaderIndex() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Assert.assertEquals((long)0L, (long)sequence.readerKeysAvailable());
        sequence.nextWriterKey();
        long diff1 = sequence.readerKeysAvailable();
        sequence.nextReaderKey();
        long diff2 = sequence.readerKeysAvailable();
        sequence.nextWriterKey();
        long diff3 = sequence.readerKeysAvailable();
        sequence.nextWriterKey();
        long diff4 = sequence.readerKeysAvailable();
        Assert.assertEquals((long)1L, (long)diff1);
        Assert.assertEquals((long)0L, (long)diff2);
        Assert.assertEquals((long)1L, (long)diff3);
        Assert.assertEquals((long)2L, (long)diff4);
    }

    @Test
    public void returnsIteratorOverNextAvailableKeys() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Assert.assertEquals((long)0L, (long)sequence.readerKeysAvailable());
        Iterator iterator = sequence.nextReaderKeys(0L);
        Assert.assertNotNull((Object)iterator);
    }

    @Test
    public void nextAvailableKeysNextReturnsNullIfReaderIndexEqualsInitialWriterIndex() {
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Iterator iterator = sequence.nextReaderKeys(1L);
        CharSequence next = (CharSequence)iterator.next();
        Assert.assertNull((Object)next);
    }

    @Test
    public void nextAvailableKeysNextReturnsNextReaderKeyIfReaderIndexLowerThanWriterIndex() {
        String expectedFirstKey = this.getNextExpectedKey(17);
        String expectedSecondKey = this.getNextExpectedKey(18);
        KeySequenceConfig config = this.createDefaultTestWriterIndexConfig(18);
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Iterator iterator = sequence.nextReaderKeys(2L);
        CharSequence readerKey1 = (CharSequence)iterator.next();
        CharSequence readerKey2 = (CharSequence)iterator.next();
        Assert.assertEquals((Object)expectedFirstKey, (Object)readerKey1);
        Assert.assertEquals((Object)expectedSecondKey, (Object)readerKey2);
    }

    @Test
    public void nextAvailableKeysNextReturnsNullIfReaderIndexLowerThanWriterIndex() {
        String expectedFirstKey = this.getNextExpectedKey(17);
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Iterator iterator = sequence.nextReaderKeys(2L);
        CharSequence next1 = (CharSequence)iterator.next();
        sequence.nextWriterKey();
        CharSequence next2 = (CharSequence)iterator.next();
        Assert.assertNull((Object)next1);
        Assert.assertEquals((Object)expectedFirstKey, (Object)next2);
    }

    @Test
    public void nextAvailableKeysHasNextReturnsTrueIfRemainingIsHigherThasZero() {
        String expectedFirstKey = this.getNextExpectedKey(17);
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        Iterator iterator = sequence.nextReaderKeys(1L);
        boolean hasNext1 = iterator.hasNext();
        sequence.nextWriterKey();
        boolean hasNext2 = iterator.hasNext();
        CharSequence next1 = (CharSequence)iterator.next();
        boolean hasNext3 = iterator.hasNext();
        Assert.assertEquals((Object)expectedFirstKey, (Object)next1);
        Assert.assertFalse((boolean)hasNext1);
        Assert.assertTrue((boolean)hasNext2);
        Assert.assertFalse((boolean)hasNext3);
    }

    @Test
    public void configSnapshotReturnsASnapshotOfCurrentState() {
        String expectedReaderKey1 = this.getNextExpectedKey(16);
        String expectedReaderKey2 = this.getNextExpectedKey(17);
        String expectedReaderKey3 = this.getNextExpectedKey(18);
        String expectedWriterKey1 = this.getNextExpectedKey(16);
        String expectedWriterKey2 = this.getNextExpectedKey(17);
        String expectedWriterKey3 = this.getNextExpectedKey(18);
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        KeySequenceConfig snapshot1 = sequence.getConfig(false);
        sequence.nextWriterKey();
        KeySequenceConfig snapshot2 = sequence.getConfig(false);
        sequence.nextWriterKey();
        KeySequenceConfig snapshot3 = sequence.getConfig(false);
        sequence.nextReaderKey();
        KeySequenceConfig snapshot4 = sequence.getConfig(false);
        sequence.nextReaderKey();
        KeySequenceConfig snapshot5 = sequence.getConfig(false);
        sequence.nextReaderKey();
        KeySequenceConfig snapshot6 = sequence.getConfig(false);
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey1), (long)snapshot1.nextReaderIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey1), (long)snapshot1.nextWriterIndex());
        Assert.assertEquals((long)snapshot1.nextReaderIndex(), (long)snapshot1.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey2), (long)snapshot2.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey1), (long)snapshot2.nextReaderIndex());
        Assert.assertNotEquals((long)snapshot2.nextReaderIndex(), (long)snapshot2.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey3), (long)snapshot3.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey1), (long)snapshot3.nextReaderIndex());
        Assert.assertNotEquals((long)snapshot3.nextReaderIndex(), (long)snapshot3.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey3), (long)snapshot4.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey2), (long)snapshot4.nextReaderIndex());
        Assert.assertNotEquals((long)snapshot4.nextReaderIndex(), (long)snapshot4.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey3), (long)snapshot5.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey3), (long)snapshot5.nextReaderIndex());
        Assert.assertEquals((long)snapshot5.nextReaderIndex(), (long)snapshot5.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey3), (long)snapshot6.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey3), (long)snapshot6.nextReaderIndex());
        Assert.assertEquals((long)snapshot6.nextReaderIndex(), (long)snapshot6.nextWriterIndex());
    }

    @Test
    public void sharedConfigReturnsLatestState() {
        String expectedReaderKey = this.getNextExpectedKey(17);
        String expectedWriterKey = this.getNextExpectedKey(17);
        KeySequenceConfig config = UUIDSequenceTest.createDefaultTestKeySequenceConfig();
        UUIDSequence sequence = this.createDefaultTestUUIDSequence(config);
        KeySequenceConfig snapshot1 = sequence.getConfig(true);
        sequence.nextWriterKey();
        KeySequenceConfig snapshot2 = sequence.getConfig(true);
        sequence.nextReaderKey();
        KeySequenceConfig snapshot3 = sequence.getConfig(true);
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey), (long)snapshot1.nextReaderIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey), (long)snapshot1.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey), (long)snapshot2.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey), (long)snapshot2.nextReaderIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedWriterKey), (long)snapshot3.nextWriterIndex());
        Assert.assertEquals((long)this.getSequenceIndex(expectedReaderKey), (long)snapshot3.nextReaderIndex());
        Assert.assertEquals((long)snapshot1.nextReaderIndex(), (long)snapshot1.nextWriterIndex());
        Assert.assertEquals((long)snapshot2.nextReaderIndex(), (long)snapshot2.nextWriterIndex());
        Assert.assertEquals((long)snapshot3.nextReaderIndex(), (long)snapshot3.nextWriterIndex());
        Assert.assertEquals((Object)snapshot1.getSource(), (Object)snapshot2.getSource());
        Assert.assertEquals((Object)snapshot2.getSource(), (Object)snapshot3.getSource());
    }

    @Test
    public void keyToUUID() {
        System.out.println(UUID.fromString("00000000-0000-0003-0000-000000014b63").getLeastSignificantBits());
    }

    public long getSequenceIndex(CharSequence expectedReaderKey1) {
        return UUID.fromString((String)expectedReaderKey1).getLeastSignificantBits();
    }

    public String getNextExpectedKey(int reservedKeys) {
        return new UUID(1L, reservedKeys).toString();
    }

    @NotNull
    public static KeySequenceConfig createDefaultTestKeySequenceConfig() {
        return new KeySequenceConfig(1L, 16L, 16L);
    }

    @NotNull
    public static KeySequence createDefaultTestKeySequence() {
        return new UUIDSequence(UUIDSequenceTest.createDefaultTestKeySequenceConfig());
    }

    private UUIDSequence createDefaultTestUUIDSequence(KeySequenceConfig sequenceConfig) {
        return new UUIDSequence(sequenceConfig);
    }

    private KeySequenceConfig createDefaultTestWriterIndexConfig(int initialWriterIndex) {
        return new KeySequenceConfig(1L, 16L, (long)initialWriterIndex);
    }

    private KeySequenceConfig createDefaultTestReaderIndexConfig(int initialReaderIndex) {
        return new KeySequenceConfig(1L, (long)initialReaderIndex, 16L);
    }
}

