/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.smoke;

import java.net.URI;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.async.AsyncLoggerConfigDelegate;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.appenders.core.util.PropertiesUtil;
import org.appenders.log4j2.elasticsearch.ElasticsearchAppender;
import org.junit.Test;

public abstract class SmokeTestBase {
    public static final String DEFAULT_APPENDER_NAME = "elasticsearchAppender";
    public static final String DEFAULT_LOGGER_NAME = "elasticsearch";
    public static final Random RANDOM = new Random();
    private final AtomicInteger localCounter = new AtomicInteger();
    public static final int INITIAL_SLEEP_PER_THREAD = 10;
    public static final int MILLIS_BEFORE_SHUTDOWN = 60000;
    public static final int MILLIS_AFTER_SHUTDOWN = 60000;
    public static final int NUMBER_OF_PRODUCERS = 100;
    public static final int LOG_SIZE = 300;
    protected boolean secure = false;
    private final AtomicInteger numberOfLogs = new AtomicInteger(1000000);

    public abstract ElasticsearchAppender.Builder createElasticsearchAppenderBuilder(boolean var1, boolean var2, boolean var3);

    protected Function<Configuration, AsyncLoggerConfigDelegate> createAsyncLoggerConfigDelegateProvider() {
        return Configuration::getAsyncLoggerConfigDelegate;
    }

    protected String createLog() {
        byte[] bytes = new byte[300];
        RANDOM.nextBytes(bytes);
        return new String(bytes);
    }

    public final void createLoggerProgrammatically(Supplier<ElasticsearchAppender.Builder> appenderBuilder, Function<Configuration, AsyncLoggerConfigDelegate> delegateSupplier) {
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        ElasticsearchAppender appender = appenderBuilder.get().build();
        appender.start();
        AppenderRef ref = AppenderRef.createAppenderRef((String)DEFAULT_APPENDER_NAME, (Level)Level.INFO, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        ((LifeCycle)delegateSupplier.apply(config)).start();
        AsyncLoggerConfig loggerConfig = (AsyncLoggerConfig)AsyncLoggerConfig.createLogger((boolean)false, (Level)Level.INFO, (String)DEFAULT_LOGGER_NAME, (String)"false", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, Level.INFO, null);
        config.addAppender((Appender)appender);
        config.addLogger(DEFAULT_LOGGER_NAME, (LoggerConfig)loggerConfig);
    }

    @Test
    public void publicDocsExampleTest() throws InterruptedException {
        System.setProperty("log4j.configurationFile", "log4j2-test.xml");
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        this.createLoggerProgrammatically(() -> this.createElasticsearchAppenderBuilder(false, false, this.secure), this.createAsyncLoggerConfigDelegateProvider());
        String loggerThatReferencesElasticsearchAppender = DEFAULT_LOGGER_NAME;
        Logger log = LogManager.getLogger((String)loggerThatReferencesElasticsearchAppender);
        log.info("Hello, World!");
        Thread.sleep(5000L);
    }

    @Test
    public void programmaticConfigTest() throws InterruptedException {
        System.setProperty("log4j.configurationFile", "log4j2-test.xml");
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.garbagefreeThreadContextMap", "true");
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        System.setProperty("AsyncLogger.RingBufferSize", "16384");
        System.setProperty("AsyncLoggerConfig.RingBufferSize", "16384");
        System.setProperty("AsyncLogger.WaitStrategy", "sleep");
        this.createLoggerProgrammatically(() -> this.createElasticsearchAppenderBuilder(false, false, this.secure), this.createAsyncLoggerConfigDelegateProvider());
        String log = this.createLog();
        Logger logger = LogManager.getLogger((String)DEFAULT_LOGGER_NAME);
        this.indexLogs(logger, null, 100, () -> log);
    }

    @Test
    public void programmaticBufferedConfigTest() throws InterruptedException {
        System.setProperty("log4j.configurationFile", "log4j2-test.xml");
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("log4j2.garbagefreeThreadContextMap", "true");
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        System.setProperty("AsyncLogger.RingBufferSize", "16384");
        System.setProperty("AsyncLogger.WaitStrategy", "sleep");
        System.setProperty("AsyncLoggerConfig.RingBufferSize", "16384");
        System.setProperty("AsyncLoggerConfig.WaitStrategy", "sleep");
        this.createLoggerProgrammatically(() -> this.createElasticsearchAppenderBuilder(false, true, this.secure), this.createAsyncLoggerConfigDelegateProvider());
        Logger logger = LogManager.getLogger((String)DEFAULT_LOGGER_NAME);
        String log = this.createLog();
        this.indexLogs(logger, null, 100, () -> log);
    }

    @Test
    public void fileOutputTest() throws InterruptedException {
        System.setProperty("log4j.configurationFile", "log4j2-file.xml");
        System.setProperty("log4j2.enable.threadlocals", "true");
        System.setProperty("log4j2.enable.direct.encoders", "true");
        System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
        System.setProperty("AsyncLogger.RingBufferSize", "16384");
        Logger logger = LogManager.getLogger((String)"file");
        String log = this.createLog();
        this.indexLogs(logger, null, 100, () -> log);
    }

    @Test
    public void xmlConfigTest() throws InterruptedException {
        AtomicInteger counter = new AtomicInteger();
        URI uri = URI.create("log4j2.xml");
        LoggerContext context = (LoggerContext)LogManager.getFactory().getContext(LogManager.class.getName(), SmokeTestBase.class.getClassLoader(), null, false, uri, null);
        context.setConfigLocation(uri);
        Logger logger = LogManager.getLogger((String)DEFAULT_LOGGER_NAME);
        this.indexLogs(logger, null, 100, () -> "Message " + counter.incrementAndGet());
    }

    @Test
    public void propertiesConfigTest() throws InterruptedException {
        System.setProperty("log4j.configurationFile", "log4j2.properties");
        AtomicInteger counter = new AtomicInteger();
        Logger logger = LogManager.getLogger((String)DEFAULT_LOGGER_NAME);
        this.indexLogs(logger, null, 100, () -> "Message " + counter.incrementAndGet());
    }

    <T> void indexLogs(Logger logger, Marker marker, int numberOfProducers, Supplier<T> logSupplier) throws InterruptedException {
        AtomicInteger sleepTime = new AtomicInteger(10);
        CountDownLatch latch = new CountDownLatch(numberOfProducers);
        int numberOfLogsToDeliver = this.numberOfLogs.get();
        AtomicInteger totalCounter = new AtomicInteger();
        for (int thIndex = 0; thIndex < numberOfProducers; ++thIndex) {
            new Thread(() -> {
                while (this.numberOfLogs.decrementAndGet() >= 0) {
                    logger.info(marker, logSupplier.get());
                    this.localCounter.incrementAndGet();
                    try {
                        Thread.sleep(sleepTime.get());
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    totalCounter.incrementAndGet();
                }
                latch.countDown();
            }).start();
        }
        int limitPerSec = PropertiesUtil.getInt("smokeTest.limitPerSec", 10000);
        while (latch.getCount() != 0L) {
            Thread.sleep(1000L);
            int count = this.localCounter.getAndSet(0);
            if (count > limitPerSec && sleepTime.get() != 1) {
                sleepTime.incrementAndGet();
            } else if (sleepTime.get() > 1) {
                sleepTime.decrementAndGet();
            }
            String stats = String.format("Sleep millis per thread: %d, Current throughput: %d; Progress: %d/%d", sleepTime.get(), count, totalCounter.get(), numberOfLogsToDeliver);
            System.out.println(stats);
        }
        Thread.sleep(60000L);
        System.out.println("Shutting down");
        LogManager.shutdown();
        Thread.sleep(60000L);
    }
}

