/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.spi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.appenders.log4j2.elasticsearch.BatchDeliveryTest;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.TestBatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class BatchEmitterServiceProviderLoadingOrderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void firstServiceLoaderWins() {
        Iterable serviceLoader1 = (Iterable)Mockito.spy(this.createTestIterable());
        ServiceLoader<BatchEmitterFactory> serviceLoader2 = ServiceLoader.load(BatchEmitterFactory.class, TestBatchEmitterFactory.class.getClassLoader());
        final BatchEmitter notExpected = (BatchEmitter)Mockito.mock(BatchEmitter.class);
        TestBatchEmitterFactory factory = new TestBatchEmitterFactory(){

            @Override
            public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
                return notExpected;
            }
        };
        Iterable serviceLoader3 = (Iterable)Mockito.spy(this.createTestIterable(factory));
        BatchEmitterServiceProvider serviceProvider = new BatchEmitterServiceProvider(Arrays.asList(serviceLoader1, serviceLoader2, serviceLoader3));
        BatchEmitter instance = serviceProvider.createInstance(0, 0, (ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build(), (FailoverPolicy)new NoopFailoverPolicy());
        Assert.assertNotNull((Object)instance);
        Assert.assertNotSame((Object)notExpected, (Object)instance);
        ((Iterable)Mockito.verify((Object)serviceLoader1, (VerificationMode)Mockito.times((int)1))).iterator();
        ((Iterable)Mockito.verify((Object)serviceLoader3, (VerificationMode)Mockito.never())).iterator();
    }

    @Test
    public void checksUntilLastIfPreviousLoaderIsEmpty() {
        Iterable serviceLoader1 = (Iterable)Mockito.spy(this.createTestIterable());
        final BatchEmitter expected = (BatchEmitter)Mockito.mock(BatchEmitter.class);
        TestBatchEmitterFactory factory = new TestBatchEmitterFactory(){

            @Override
            public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
                return expected;
            }
        };
        Iterable serviceLoader2 = (Iterable)Mockito.spy(this.createTestIterable(factory));
        BatchEmitterServiceProvider serviceProvider = new BatchEmitterServiceProvider(Arrays.asList(serviceLoader1, serviceLoader2));
        BatchEmitter instance = serviceProvider.createInstance(0, 0, (ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build(), (FailoverPolicy)new NoopFailoverPolicy());
        ((Iterable)Mockito.verify((Object)serviceLoader1, (VerificationMode)Mockito.times((int)1))).iterator();
        Assert.assertSame((Object)expected, (Object)instance);
    }

    @Test
    public void checksUntilLastIfPreviousLoaderIsNull() {
        Iterable<BatchEmitterFactory> serviceLoader2 = this.createTestIterable(new TestBatchEmitterFactory());
        BatchEmitterServiceProvider serviceProvider = new BatchEmitterServiceProvider(Arrays.asList(null, serviceLoader2));
        serviceProvider.createInstance(0, 0, (ClientObjectFactory)BatchDeliveryTest.createTestObjectFactoryBuilder().build(), (FailoverPolicy)new NoopFailoverPolicy());
    }

    private Iterable<BatchEmitterFactory> createTestIterable(TestBatchEmitterFactory testBatchEmitterFactory) {
        return new TestIterable(testBatchEmitterFactory);
    }

    private Iterable<BatchEmitterFactory> createTestIterable() {
        return new TestIterable(null);
    }

    private class TestIterable
    implements Iterable<BatchEmitterFactory> {
        private final BatchEmitterFactory value;

        public TestIterable(BatchEmitterFactory value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Iterator<BatchEmitterFactory> iterator() {
            return new Iterator<BatchEmitterFactory>(){
                int left;
                {
                    this.left = TestIterable.this.value != null ? 1 : 0;
                }

                @Override
                public boolean hasNext() {
                    return this.left-- > 0;
                }

                @Override
                public BatchEmitterFactory next() {
                    return TestIterable.this.value;
                }
            };
        }

        @Override
        public void forEach(Consumer<? super BatchEmitterFactory> action) {
            throw new UnsupportedOperationException("irrelevant here");
        }

        @Override
        public Spliterator<BatchEmitterFactory> spliterator() {
            throw new UnsupportedOperationException("irrelevant here");
        }
    }
}

