/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.failover.FailoverListener;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;

@Plugin(name="AsyncBatchDelivery", category="Core", elementType="batchDelivery", printObject=true)
public class AsyncBatchDelivery
implements BatchDelivery<String> {
    private static final Logger LOG = InternalLogging.getLogger();
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final BatchOperations batchOperations;
    private final BatchEmitter batchEmitter;
    private final IndexTemplate indexTemplate;
    private final ClientObjectFactory<Object, Object> objectFactory;
    private final FailoverPolicy failoverPolicy;
    private final long delayShutdownInMillis;

    @Deprecated
    public AsyncBatchDelivery(int batchSize, int deliveryInterval, ClientObjectFactory objectFactory, FailoverPolicy failoverPolicy, IndexTemplate indexTemplate) {
        this.batchOperations = objectFactory.createBatchOperations();
        this.batchEmitter = this.createBatchEmitterServiceProvider().createInstance(batchSize, deliveryInterval, objectFactory, failoverPolicy);
        this.indexTemplate = indexTemplate;
        this.objectFactory = objectFactory;
        this.failoverPolicy = failoverPolicy;
        this.delayShutdownInMillis = 5000L;
    }

    protected AsyncBatchDelivery(Builder builder) {
        this.batchOperations = builder.clientObjectFactory.createBatchOperations();
        this.batchEmitter = this.createBatchEmitterServiceProvider().createInstance(builder.batchSize, builder.deliveryInterval, builder.clientObjectFactory, builder.failoverPolicy);
        this.indexTemplate = builder.indexTemplate;
        this.objectFactory = builder.clientObjectFactory;
        this.failoverPolicy = builder.failoverPolicy;
        this.delayShutdownInMillis = builder.shutdownDelayMillis;
    }

    @Override
    public void add(String indexName, String log) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, log));
    }

    @Override
    public void add(String indexName, ItemSource source) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, source));
    }

    protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
        return new BatchEmitterServiceProvider();
    }

    protected FailoverListener failoverListener() {
        return event -> {
            this.add(event.getInfo().getTargetName(), (ItemSource)event);
            return true;
        };
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void start() {
        if (!this.objectFactory.isStarted()) {
            this.objectFactory.start();
        }
        if (this.indexTemplate != null) {
            this.objectFactory.addOperation(() -> this.objectFactory.execute(this.indexTemplate));
        }
        this.batchEmitter.start();
        if (!LifeCycle.of(this.failoverPolicy).isStarted()) {
            this.failoverPolicy.addListener(this.failoverListener());
            LifeCycle.of(this.failoverPolicy).start();
        }
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        LOG.debug("Stopping {}", this.getClass().getSimpleName());
        if (!LifeCycle.of(this.failoverPolicy).isStopped()) {
            LifeCycle.of(this.failoverPolicy).stop(this.delayShutdownInMillis, true);
        }
        if (!this.batchEmitter.isStopped()) {
            this.batchEmitter.stop(this.delayShutdownInMillis, false);
        }
        if (!this.objectFactory.isStopped()) {
            this.objectFactory.stop();
        }
        this.state = LifeCycle.State.STOPPED;
        LOG.debug("{} stopped", this.getClass().getSimpleName());
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<AsyncBatchDelivery> {
        public static final int DEFAULT_BATCH_SIZE = 1000;
        public static final int DEFAULT_DELIVERY_INTERVAL = 1000;
        public static final FailoverPolicy DEFAULT_FAILOVER_POLICY = new NoopFailoverPolicy();
        public static final long DEFAULT_SHUTDOWN_DELAY = 5000L;
        @PluginElement(value="elasticsearchClientFactory")
        @Required(message="No Elasticsearch client factory [JestHttp|ElasticsearchBulkProcessor] provided for AsyncBatchDelivery")
        private ClientObjectFactory clientObjectFactory;
        @PluginBuilderAttribute
        private int deliveryInterval = 1000;
        @PluginBuilderAttribute
        private int batchSize = 1000;
        @PluginElement(value="failoverPolicy")
        private FailoverPolicy failoverPolicy = DEFAULT_FAILOVER_POLICY;
        @PluginElement(value="indexTemplate")
        private IndexTemplate indexTemplate;
        @PluginBuilderAttribute(value="shutdownDelayMillis")
        public long shutdownDelayMillis = 5000L;

        public AsyncBatchDelivery build() {
            if (this.clientObjectFactory == null) {
                throw new ConfigurationException("No Elasticsearch client factory [JestHttp|ElasticsearchBulkProcessor] provided for AsyncBatchDelivery");
            }
            return new AsyncBatchDelivery(this);
        }

        public Builder withClientObjectFactory(ClientObjectFactory clientObjectFactory) {
            this.clientObjectFactory = clientObjectFactory;
            return this;
        }

        public Builder withDeliveryInterval(int deliveryInterval) {
            this.deliveryInterval = deliveryInterval;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withFailoverPolicy(FailoverPolicy failoverPolicy) {
            this.failoverPolicy = failoverPolicy;
            return this;
        }

        public Builder withIndexTemplate(IndexTemplate indexTemplate) {
            this.indexTemplate = indexTemplate;
            return this;
        }

        public Builder withShutdownDelayMillis(long shutdownDelayMillis) {
            this.shutdownDelayMillis = shutdownDelayMillis;
            return this;
        }
    }
}

