/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.function.Consumer;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;

public class DelayedShutdown
extends Thread {
    private static final Logger LOG = InternalLogging.getLogger();
    public static final int DEFAULT_DECREMENT_IN_MILLIS = 1000;
    private final Runnable onStart;
    private long delay = 0L;
    private long decrementInMillis = 1000L;
    private Consumer<Long> onDecrement = remaining -> {};
    private Runnable afterDelay = () -> {};
    private Consumer<Exception> onError = exception -> LOG.warn("Shutdown interrupted: {}", exception.getMessage());

    public DelayedShutdown(Runnable onStart) {
        super("DelayedShutdown");
        this.onStart = onStart;
    }

    public DelayedShutdown onError(Consumer<Exception> onError) {
        this.onError = onError;
        return this;
    }

    public DelayedShutdown afterDelay(Runnable afterDelay) {
        this.afterDelay = afterDelay;
        return this;
    }

    public DelayedShutdown onDecrement(Consumer<Long> onDecrement) {
        this.onDecrement = onDecrement;
        return this;
    }

    public DelayedShutdown delay(long delayInMillis) {
        this.delay = delayInMillis;
        return this;
    }

    public DelayedShutdown decrementInMillis(int decrementInMillis) {
        this.decrementInMillis = decrementInMillis;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            long start = System.currentTimeMillis();
            this.onStart.run();
            long took = System.currentTimeMillis() - start;
            for (long remaining = this.delay - took; remaining > 0L; remaining -= this.decrementInMillis) {
                this.onDecrement.accept(remaining);
                DelayedShutdown.sleep(this.decrementInMillis);
            }
        }
        catch (InterruptedException e) {
            this.onError.accept(e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.onError.accept(e);
        }
        finally {
            this.afterDelay.run();
        }
    }

    public final void start(boolean runInBackground) {
        if (runInBackground) {
            this.start();
            return;
        }
        this.run();
    }
}

