/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.ValueResolver;

@Plugin(name="IndexTemplate", category="Core", elementType="indexTemplate", printObject=true)
public class IndexTemplate {
    public static final String PLUGIN_NAME = "IndexTemplate";
    public static final String ELEMENT_TYPE = "indexTemplate";
    private String name;
    private String source;

    protected IndexTemplate(String name, String source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<IndexTemplate> {
        public static final String CLASSPATH_PREFIX = "classpath:";
        @PluginAttribute(value="name")
        @Required
        private String name;
        @PluginAttribute(value="path")
        private String path;
        @PluginValue(value="sourceString")
        private String source;
        @Deprecated
        @PluginConfiguration
        private Configuration configuration;
        @Deprecated
        private ValueResolver valueResolver;

        public IndexTemplate build() {
            if (this.name == null) {
                throw new ConfigurationException("No name provided for IndexTemplate");
            }
            if (this.path == null && this.source == null || this.path != null && this.source != null) {
                throw new ConfigurationException("Either path or source have to be provided for IndexTemplate");
            }
            String source = this.getValueResolver().resolve(this.loadSource());
            return new IndexTemplate(this.name, source);
        }

        @Deprecated
        ValueResolver getValueResolver() {
            if (this.valueResolver != null) {
                return this.valueResolver;
            }
            if (this.configuration != null) {
                return new Log4j2Lookup(this.configuration.getStrSubstitutor());
            }
            return ValueResolver.NO_OP;
        }

        private String loadSource() {
            if (this.source != null) {
                return this.source;
            }
            if (this.path.contains(CLASSPATH_PREFIX)) {
                return this.loadClasspathResource();
            }
            return this.loadFileSystemResource();
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Deprecated
        public Builder withValueResolver(ValueResolver valueResolver) {
            this.valueResolver = valueResolver;
            return this;
        }

        private String loadClasspathResource() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(ClassLoader.getSystemClassLoader().getResourceAsStream(this.path.replace(CLASSPATH_PREFIX, "")), "UTF-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }

        private String loadFileSystemResource() {
            try {
                return new String(Files.readAllBytes(Paths.get(this.path, new String[0])));
            }
            catch (IOException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

