/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;

public class ItemSourceAppender
implements ItemAppender<LogEvent> {
    static final Logger LOG = InternalLogging.getLogger();
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final BatchDelivery batchDelivery;
    private final Function<LogEvent, ItemSource> serializer;

    public ItemSourceAppender(BatchDelivery batchDelivery, Function<LogEvent, ItemSource> serializer) {
        this.batchDelivery = batchDelivery;
        this.serializer = serializer;
    }

    @Override
    public final void append(String formattedIndexName, LogEvent event) {
        this.batchDelivery.add(formattedIndexName, this.serializer.apply(event));
    }

    @Override
    public void start() {
        this.batchDelivery.start();
        this.state = LifeCycle.State.STARTED;
        LOG.debug("{} started", this.getClass().getSimpleName());
    }

    @Override
    public void stop() {
        LOG.debug("Stopping {}", this.getClass().getSimpleName());
        if (!this.batchDelivery.isStopped()) {
            this.batchDelivery.stop();
        }
        this.state = LifeCycle.State.STOPPED;
        LOG.debug("{} stopped", this.getClass().getSimpleName());
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

