/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.jackson.ExtendedLog4j2JsonModule;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.message.Message;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ItemSourceLayout;
import org.appenders.log4j2.elasticsearch.JacksonAfterburnerModuleConfigurer;
import org.appenders.log4j2.elasticsearch.JacksonHandlerInstantiator;
import org.appenders.log4j2.elasticsearch.JacksonMixIn;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.Log4j2Lookup;
import org.appenders.log4j2.elasticsearch.SingleThreadJsonFactory;
import org.appenders.log4j2.elasticsearch.StringItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.appenders.log4j2.elasticsearch.VirtualPropertyFilter;

@Plugin(name="JacksonJsonLayout", category="Core", elementType="layout", printObject=true)
public class JacksonJsonLayout
extends AbstractLayout<ItemSource>
implements ItemSourceLayout,
LifeCycle {
    public static final String PLUGIN_NAME = "JacksonJsonLayout";
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final ObjectWriter objectWriter;
    private final ItemSourceFactory itemSourceFactory;

    protected JacksonJsonLayout(Configuration config, ObjectWriter configuredWriter, ItemSourceFactory itemSourceFactory) {
        super(config, null, null);
        this.objectWriter = configuredWriter;
        this.itemSourceFactory = itemSourceFactory;
    }

    public String getContentType() {
        return "application/json";
    }

    public byte[] toByteArray(LogEvent event) {
        throw new UnsupportedOperationException("Cannot return unwrapped byte array. Use ItemSource based API");
    }

    public final ItemSource toSerializable(LogEvent event) {
        return this.serialize(event);
    }

    @Override
    public final ItemSource serialize(LogEvent event) {
        return this.itemSourceFactory.create(event, this.objectWriter);
    }

    @Override
    public final ItemSource serialize(Message message) {
        return this.itemSourceFactory.create(message, this.objectWriter);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void start() {
        this.itemSourceFactory.start();
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        if (!this.itemSourceFactory.isStopped()) {
            this.itemSourceFactory.stop();
        }
        this.state = LifeCycle.State.STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class Builder
    extends AbstractLayout.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<JacksonJsonLayout> {
        static final ItemSourceFactory DEFAULT_SOURCE_FACTORY = StringItemSourceFactory.newBuilder().build();
        @PluginElement(value="itemSourceFactory")
        private ItemSourceFactory itemSourceFactory = DEFAULT_SOURCE_FACTORY;
        @PluginElement(value="jacksonMixIn")
        private JacksonMixIn[] mixins = new JacksonMixIn[0];
        @PluginElement(value="VirtualProperty")
        private VirtualProperty[] virtualProperties = new VirtualProperty[0];
        @PluginElement(value="VirtualPropertyFilter")
        private VirtualPropertyFilter[] virtualPropertyFilters = new VirtualPropertyFilter[0];
        @PluginBuilderAttribute(value="afterburner")
        private boolean useAfterburner;
        @PluginBuilderAttribute(value="singleThread")
        private boolean singleThread;

        public JacksonJsonLayout build() {
            if (this.getConfiguration() == null) {
                throw new ConfigurationException("No Configuration instance provided for JacksonJsonLayout");
            }
            return new JacksonJsonLayout(this.getConfiguration(), this.createConfiguredWriter(Arrays.asList(this.mixins)), this.itemSourceFactory);
        }

        protected ObjectWriter createConfiguredWriter(List<JacksonMixIn> mixins) {
            ObjectMapper objectMapper = this.createDefaultObjectMapper();
            objectMapper.registerModule((Module)new ExtendedLog4j2JsonModule());
            if (this.useAfterburner) {
                new JacksonAfterburnerModuleConfigurer().configure(objectMapper);
            }
            for (JacksonMixIn jacksonMixIn : mixins) {
                objectMapper.addMixIn(jacksonMixIn.getTargetClass(), jacksonMixIn.getMixInClass());
            }
            ValueResolver valueResolver = this.createValueResolver();
            for (VirtualProperty property : this.virtualProperties) {
                if (property.isDynamic()) continue;
                property.setValue(valueResolver.resolve(property.getValue()));
            }
            SerializationConfig serializationConfig = (SerializationConfig)objectMapper.getSerializationConfig().with((HandlerInstantiator)new JacksonHandlerInstantiator(this.virtualProperties, valueResolver, this.virtualPropertyFilters));
            objectMapper.setConfig(serializationConfig);
            return objectMapper.writer((PrettyPrinter)new MinimalPrettyPrinter());
        }

        protected ValueResolver createValueResolver() {
            return new Log4j2Lookup(this.getConfiguration().getStrSubstitutor());
        }

        protected ObjectMapper createDefaultObjectMapper() {
            return new ExtendedObjectMapper(this.createJsonFactory()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false);
        }

        protected JsonFactory createJsonFactory() {
            if (this.singleThread) {
                return new SingleThreadJsonFactory();
            }
            return new JsonFactory();
        }

        public Builder withItemSourceFactory(ItemSourceFactory itemSourceFactory) {
            this.itemSourceFactory = itemSourceFactory;
            return this;
        }

        public Builder withMixins(JacksonMixIn ... mixins) {
            this.mixins = mixins;
            return this;
        }

        public Builder withVirtualProperties(VirtualProperty ... virtualProperties) {
            this.virtualProperties = virtualProperties;
            return this;
        }

        public Builder withVirtualPropertyFilters(VirtualPropertyFilter[] virtualPropertyFilters) {
            this.virtualPropertyFilters = virtualPropertyFilters;
            return this;
        }

        public Builder withAfterburner(boolean useAfterburner) {
            this.useAfterburner = useAfterburner;
            return this;
        }

        public Builder withSingleThread(boolean singleThread) {
            this.singleThread = singleThread;
            return this;
        }
    }
}

